/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.storage;

import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.Unmarshaller;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.migration.UrlResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.storage.embed.StorageEmbeddedImageUnmarshaller;
import com.atlassian.confluence.content.render.xhtml.storage.macro.StorageMacroConstants;
import com.atlassian.confluence.content.render.xhtml.storage.resource.identifiers.StorageResourceIdentifierUnmarshaller;
import com.atlassian.confluence.content.render.xhtml.transformers.FragmentTransformer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.manager.HandyLinkResolver;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StorageConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageConverter.class);
    private static final Pattern HEADER_START = Pattern.compile("<h(\\d)");
    private static final Pattern HEADER_END = Pattern.compile("</h\\d>");
    private final HandyLinkResolver handyLinkResolver;
    private final XmlEventReaderFactory xmlEventReaderFactory;
    private final StorageEmbeddedImageUnmarshaller embeddedImageUnmarshaller;
    private final FragmentTransformer fragmentTransformer;
    private final ConfluenceContentManager contentManager;
    private final GlobalSettingsManager settingsManager;
    private final XhtmlContent xhtmlContent;

    public StorageConverter(HandyLinkResolver handyLinkResolver, XmlEventReaderFactory xmlEventReaderFactory, FragmentTransformer fragmentTransformer, ConfluenceContentManager contentManager, GlobalSettingsManager settingsManager, XhtmlContent xhtmlContent) {
        this.handyLinkResolver = handyLinkResolver;
        this.xmlEventReaderFactory = xmlEventReaderFactory;
        this.fragmentTransformer = fragmentTransformer;
        this.contentManager = contentManager;
        this.settingsManager = settingsManager;
        this.xhtmlContent = xhtmlContent;
        this.embeddedImageUnmarshaller = new StorageEmbeddedImageUnmarshaller((Unmarshaller)new StorageResourceIdentifierUnmarshaller(), xmlEventReaderFactory);
    }

    public static String sanitize(String body) {
        Matcher matcher = HEADER_START.matcher(body);
        while (matcher.find()) {
            body = body.replace(matcher.group(0), "<p class=\"h" + matcher.group(1) + "\"");
        }
        matcher = HEADER_END.matcher(body);
        while (matcher.find()) {
            body = body.replace(matcher.group(0), "</p>");
        }
        return body.replace("<a ", "<span ").replace("</a>", "</span>");
    }

    public String convertToView(String storage, ConversionContext context) {
        try {
            return this.xhtmlContent.convertStorageToView(storage, context);
        }
        catch (Exception e) {
            log.error("Failed to convert content to view", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertToPlainText(String storage, int limit) {
        String string;
        XMLEventReader xmlEventReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(storage), true);
            int macroDepth = 0;
            int richTextDepth = 0;
            while (xmlEventReader.hasNext() && stringBuilder.length() < limit) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    if (StorageMacroConstants.MACRO_V2_ELEMENT.equals(event.asStartElement().getName())) {
                        ++macroDepth;
                    } else if (StorageMacroConstants.RICH_TEXT_BODY_PARAMETER_ELEMENT.equals(event.asStartElement().getName())) {
                        ++richTextDepth;
                    }
                    if (!this.isNewLine((StartElement)event) || stringBuilder.length() <= 0) continue;
                    stringBuilder.append(" ");
                    continue;
                }
                if (event.isCharacters()) {
                    if (macroDepth != richTextDepth) continue;
                    stringBuilder.append(event.asCharacters().getData());
                    continue;
                }
                if (event.isEntityReference()) {
                    if (macroDepth != richTextDepth) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    }
                    stringBuilder.append(((EntityReference)event).getDeclaration().getReplacementText());
                    continue;
                }
                if (!event.isEndElement()) continue;
                if (StorageMacroConstants.MACRO_V2_ELEMENT.equals(event.asEndElement().getName())) {
                    --macroDepth;
                    continue;
                }
                if (!StorageMacroConstants.RICH_TEXT_BODY_PARAMETER_ELEMENT.equals(event.asEndElement().getName())) continue;
                --richTextDepth;
            }
            String text = stringBuilder.toString().trim();
            if ((text = text.trim().replaceAll("  +", " ")).length() > limit) {
                text = text.substring(0, limit);
            }
            string = text;
        }
        catch (XMLStreamException e) {
            String string2;
            try {
                log.error("Failed to convert storage to plain text", (Throwable)e);
                string2 = "";
            }
            catch (Throwable throwable) {
                StaxUtils.closeQuietly(xmlEventReader);
                throw throwable;
            }
            StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
            return string2;
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getFirstImageUrl(String storage, ConversionContext context, ContentEntityObject page) {
        block9: {
            block8: {
                block7: {
                    block6: {
                        start = storage.indexOf("<ac:image");
                        end = storage.indexOf("</ac:image>") + 11;
                        if (start < 0 || end <= start) break block9;
                        imageStorage = storage.substring(start, end);
                        xmlEventReader = null;
                        xmlEventReader = this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(imageStorage), false);
                        embeddedImage = this.embeddedImageUnmarshaller.unmarshal(xmlEventReader, this.fragmentTransformer, context);
                        ri = embeddedImage.getResourceIdentifier();
                        if (!(ri instanceof AttachmentResourceIdentifier)) ** GOTO lbl32
                        attachmentResourceIdentifier = (AttachmentResourceIdentifier)ri;
                        acri = attachmentResourceIdentifier.getAttachmentContainerResourceIdentifier();
                        content = this.handyLinkResolver.getContent(context, (ResourceIdentifier)acri);
                        filename = attachmentResourceIdentifier.getResourceName();
                        if (!Objects.nonNull(content)) ** GOTO lbl25
                        attachmentContentOptional = this.contentManager.getAttachmentContent(content, filename);
                        if (!attachmentContentOptional.isPresent()) break block6;
                        attachmentContent = attachmentContentOptional.get();
                        var16_20 = this.settingsManager.getGlobalSettings().getBaseUrl() + ((Link)attachmentContent.getLinks().get(LinkType.DOWNLOAD)).getPath();
                        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
                        return var16_20;
                    }
                    break block7;
lbl25:
                    // 1 sources

                    if (!Objects.nonNull(page) || (attachment = page.getAttachmentNamed(filename)) == null) break block7;
                    var15_19 = this.settingsManager.getGlobalSettings().getBaseUrl() + ((Attachment)attachment.getLatestVersion()).getDownloadPath();
                    StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
                    return var15_19;
                }
                try {
                    break block8;
lbl32:
                    // 1 sources

                    if (!(ri instanceof UrlResourceIdentifier)) break block8;
                    var10_12 = ((UrlResourceIdentifier)ri).getUrl();
                }
                catch (Exception e) {
                    try {
                        StorageConverter.log.error("Failed to convert storage to plain text", (Throwable)e);
                    }
                    catch (Throwable var17_21) {
                        StaxUtils.closeQuietly(xmlEventReader);
                        throw var17_21;
                    }
                    StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
                }
                StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
                return var10_12;
            }
            StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        }
        return null;
    }

    private boolean isNewLine(StartElement event) {
        String startElementLocalPart = event.getName().getLocalPart();
        return "p".equals(startElementLocalPart) || "br".equals(startElementLocalPart);
    }
}

