/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.settings.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.stiltsoft.confluence.handy.macros.settings.HandyTasksSettingsService;
import com.stiltsoft.confluence.handy.macros.settings.dao.HandyTasksSettingsDao;
import com.stiltsoft.confluence.handy.macros.settings.dao.activeobjects.HandyTasksSettingsEntity;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class DefaultHandyTasksSettingsService
implements HandyTasksSettingsService {
    private final HandyTasksSettingsDao handyTasksSettingsDao;
    private final Cache<String, Boolean> cache;

    public DefaultHandyTasksSettingsService(HandyTasksSettingsDao handyTasksSettingsDao, CacheManager cacheManager) {
        this.handyTasksSettingsDao = handyTasksSettingsDao;
        this.cache = cacheManager.getCache(this.getClass().getName());
        this.cache.removeAll();
    }

    @Override
    public boolean isEnabled(String owner) {
        return this.getValueOrTrue(owner);
    }

    @Override
    public void setEnabled(String owner, boolean enabled) {
        this.setValue(owner, enabled);
    }

    private boolean getValueOrTrue(String key) {
        if (this.isCached(key)) {
            return this.getFromCacheOrTrue(key);
        }
        boolean value = this.findAndGetOrTrue(key);
        this.cache.put((Object)key, (Object)value);
        return value;
    }

    private void setValue(String key, boolean value) {
        HandyTasksSettingsEntity entity = this.findOrCreateNewEntity(key);
        entity.setEnabled(value);
        entity.save();
        this.cache.put((Object)key, (Object)value);
    }

    private boolean findAndGetOrTrue(String key) {
        return this.find(key).map(HandyTasksSettingsEntity::getEnabled).orElse(true);
    }

    private HandyTasksSettingsEntity findOrCreateNewEntity(String key) {
        return this.find(key).orElseGet(() -> {
            HandyTasksSettingsEntity newEntity = this.handyTasksSettingsDao.createHandyTasksSettingsEntity();
            newEntity.setOwner(key);
            return newEntity;
        });
    }

    private Optional<HandyTasksSettingsEntity> find(String key) {
        return this.handyTasksSettingsDao.findHandyTasksSettingsEntityByKey(key);
    }

    private boolean isCached(String key) {
        return this.cache.containsKey((Object)key);
    }

    private boolean getFromCacheOrTrue(String key) {
        return Optional.ofNullable((Boolean)this.cache.get((Object)key)).orElse(true);
    }
}

