/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.settings.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.stiltsoft.confluence.handy.macros.settings.HandyHeaderSettingsService;
import com.stiltsoft.confluence.handy.macros.settings.dao.HandyHeaderSettingsDao;
import com.stiltsoft.confluence.handy.macros.settings.dao.activeobjects.HandyHeaderSettingsEntity;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class DefaultHandyHeaderSettingsService
implements HandyHeaderSettingsService {
    private final Cache<String, Boolean> cache;
    private final HandyHeaderSettingsDao handyHeaderSettingsDao;

    public DefaultHandyHeaderSettingsService(HandyHeaderSettingsDao handyHeaderSettingsDao, CacheManager cacheManager) {
        this.handyHeaderSettingsDao = handyHeaderSettingsDao;
        this.cache = cacheManager.getCache(this.getClass().getName());
        this.cache.removeAll();
    }

    @Override
    public boolean isEnabled(String owner) {
        return this.getValueOrTrue(owner);
    }

    @Override
    public void setEnabled(String owner, boolean enabled) {
        this.setValue(owner, enabled);
    }

    private boolean getValueOrTrue(String key) {
        if (this.isCached(key)) {
            return this.getFromCacheOrTrue(key);
        }
        boolean value = this.findAndGetOrTrue(key);
        this.cache.put((Object)key, (Object)value);
        return value;
    }

    private void setValue(String key, boolean value) {
        HandyHeaderSettingsEntity entity = this.findOrCreateNewEntity(key);
        entity.setEnabled(value);
        entity.save();
        this.cache.put((Object)key, (Object)value);
    }

    private boolean findAndGetOrTrue(String key) {
        return this.find(key).map(HandyHeaderSettingsEntity::getEnabled).orElse(true);
    }

    private HandyHeaderSettingsEntity findOrCreateNewEntity(String key) {
        return this.find(key).orElseGet(() -> {
            HandyHeaderSettingsEntity newEntity = this.handyHeaderSettingsDao.createHandyHeaderSettingsEntity();
            newEntity.setOwner(key);
            return newEntity;
        });
    }

    private Optional<HandyHeaderSettingsEntity> find(String key) {
        return this.handyHeaderSettingsDao.findHandyHeaderSettingsEntityByKey(key);
    }

    private boolean isCached(String key) {
        return this.cache.containsKey((Object)key);
    }

    private boolean getFromCacheOrTrue(String key) {
        return Optional.ofNullable((Boolean)this.cache.get((Object)key)).orElse(true);
    }
}

