/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.service.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.Target;
import com.atlassian.confluence.api.service.permissions.OperationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ConfluenceContent;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceSpaceManager;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.util.ConfigLevels;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class DefaultHandyPermissionService
implements HandyPermissionService {
    private final DraftManager draftManager;
    private final OperationService operationService;
    private final PermissionManager permissionManager;
    private final ConfluenceSpaceManager confluenceSpaceManager;
    private final ConfluenceAccessManager confluenceAccessManager;
    private final ConfluenceContentManager confluenceContentManager;

    @Override
    public boolean isOwnerPermitted(String owner) {
        if (owner.equals("global")) {
            return this.isCurrentUserConfluenceAdmin();
        }
        if (owner.startsWith("space:")) {
            String spaceKey = ConfigLevels.splitOwnerAndGetKey(owner);
            return this.confluenceSpaceManager.getSpaceByKey(spaceKey).map(space -> this.operationService.getAvailableOperations(Target.forModelObject((Object)space))).map(operationCheckResults -> operationCheckResults.stream().anyMatch(operationCheckResult -> OperationKey.UPDATE.equals((Object)operationCheckResult.getOperationKey()))).orElse(Boolean.FALSE);
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String userKey = ConfigLevels.splitOwnerAndGetKey(owner);
        return user.getKey().getStringValue().equals(userKey);
    }

    @Override
    public boolean isConfluenceAdmin(User user) {
        return this.permissionManager.isConfluenceAdministrator(user);
    }

    @Override
    public boolean hasUseConfluencePermission(User user) {
        return this.confluenceAccessManager.getUserAccessStatus(user).canUseConfluence();
    }

    @Override
    public boolean isCurrentUserWithoutConfluenceUsePermission() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return !this.confluenceAccessManager.getUserAccessStatus(user).canUseConfluence();
    }

    @Override
    public boolean hasEntityEditPermission(User user, @Nullable ContentEntityObject ceo) {
        return ceo == null || ceo.isLatestVersion() && this.hasUseConfluencePermission(user) && this.hasPermission(user, Permission.EDIT, ceo);
    }

    @Override
    public boolean hasCurrentUserEntityEditPermission(@Nullable ContentEntityObject ceo) {
        return this.hasEntityEditPermission((User)AuthenticatedUserThreadLocal.get(), ceo);
    }

    @Override
    public boolean hasCurrentUserEntityReadPermission(@Nullable ContentEntityObject ceo) {
        return this.hasPageReadPermission((User)AuthenticatedUserThreadLocal.get(), ceo);
    }

    @Override
    public boolean hasCurrentUserContentEditPermission(@Nullable Content content) {
        if (this.isCurrentUserWithoutConfluenceUsePermission()) {
            return false;
        }
        if (Objects.isNull(content)) {
            return false;
        }
        return this.hasUpdatePermission(content);
    }

    @Override
    public boolean hasCurrentUserContentEditPermission(@Nullable Long contentId) {
        if (this.isCurrentUserWithoutConfluenceUsePermission()) {
            return false;
        }
        if (Objects.isNull(contentId)) {
            return true;
        }
        return this.confluenceContentManager.getConfluenceContent(contentId).map(this::hasCurrentUserConfluenceContentEditPermission).orElseGet(this.tryToFindLegacyDraftAndCheckEditPermission(contentId));
    }

    @Override
    public boolean hasCurrentUserContentReadPermission(@Nullable Long contentId) {
        if (this.isCurrentUserWithoutConfluenceUsePermission()) {
            return false;
        }
        if (Objects.isNull(contentId)) {
            return true;
        }
        return this.confluenceContentManager.getConfluenceContent(contentId).map(this::hasCurrentUserConfluenceContentReadPermission).orElseGet(this.tryToFindLegacyDraftAndCheckReadPermission(contentId));
    }

    @Override
    public boolean hasCurrentUserSpaceReadPermission(String spaceKey) {
        return this.confluenceSpaceManager.getSpaceByKey(spaceKey).isPresent();
    }

    @Override
    public boolean hasCurrentUserConfluenceContentReadPermission(ConfluenceContent confluenceContent) {
        Optional<Content> contentOptional = confluenceContent.getContentOptional();
        Optional<ContentTemplate> contentTemplateOptional = confluenceContent.getContentTemplateOptional();
        return contentOptional.map(content -> true).orElseGet(() -> contentTemplateOptional.isPresent() && this.hasCurrentUserContentTemplateViewPermission((ContentTemplate)contentTemplateOptional.get()));
    }

    @Override
    public boolean hasCurrentUserConfluenceContentEditPermission(ConfluenceContent confluenceContent) {
        Optional<Content> abstractPageOptional = confluenceContent.getContentOptional();
        Optional<ContentTemplate> contentTemplateOptional = confluenceContent.getContentTemplateOptional();
        return abstractPageOptional.map(this::hasCurrentUserContentEditPermission).orElseGet(() -> contentTemplateOptional.isPresent() && this.hasCurrentUserContentTemplateEditPermission((ContentTemplate)contentTemplateOptional.get()));
    }

    private boolean isCurrentUserConfluenceAdmin() {
        return this.isConfluenceAdmin((User)AuthenticatedUserThreadLocal.get());
    }

    private boolean hasPageReadPermission(User user, @Nullable ContentEntityObject ceo) {
        return this.hasUseConfluencePermission(user) && this.hasPermission(user, Permission.VIEW, ceo);
    }

    private boolean hasPermission(User user, Permission permission, @Nullable ContentEntityObject ceo) {
        return ceo == null || this.permissionManager.hasPermission(user, permission, (Object)ceo);
    }

    private boolean hasCurrentUserContentTemplateEditPermission(ContentTemplate contentTemplate) {
        if (this.isGlobalTemplate(contentTemplate)) {
            return this.isCurrentUserConfluenceAdmin();
        }
        return contentTemplate.space().map(space -> this.operationService.getAvailableOperations(Target.forModelObject((Object)space))).map(operationCheckResults -> operationCheckResults.stream().anyMatch(operationCheckResult -> OperationKey.UPDATE.equals((Object)operationCheckResult.getOperationKey()))).orElse(Boolean.FALSE);
    }

    private boolean hasCurrentUserContentTemplateViewPermission(ContentTemplate contentTemplate) {
        if (!contentTemplate.space().isPresent()) {
            return this.isCurrentUserConfluenceAdmin();
        }
        return contentTemplate.space().map(space -> this.operationService.getAvailableOperations(Target.forModelObject((Object)space))).map(operationCheckResults -> operationCheckResults.stream().anyMatch(operationCheckResult -> OperationKey.READ.equals((Object)operationCheckResult.getOperationKey()))).orElse(Boolean.FALSE);
    }

    private boolean hasUpdatePermission(Content content) {
        return this.operationService.getAvailableOperations(Target.forModelObject((Object)content)).stream().anyMatch(operationCheckResult -> OperationKey.UPDATE.equals((Object)operationCheckResult.getOperationKey()));
    }

    private Supplier<Boolean> tryToFindLegacyDraftAndCheckEditPermission(Long contentId) {
        return () -> {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            Draft draft = this.draftManager.getDraft(contentId.longValue());
            return this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)draft);
        };
    }

    private Supplier<Boolean> tryToFindLegacyDraftAndCheckReadPermission(Long contentId) {
        return () -> {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            Draft draft = this.draftManager.getDraft(contentId.longValue());
            return this.permissionManager.hasPermission(currentUser, Permission.VIEW, (Object)draft);
        };
    }

    private boolean isGlobalTemplate(ContentTemplate contentTemplate) {
        return !contentTemplate.space().isPresent();
    }

    @Generated
    public DefaultHandyPermissionService(DraftManager draftManager, OperationService operationService, PermissionManager permissionManager, ConfluenceSpaceManager confluenceSpaceManager, ConfluenceAccessManager confluenceAccessManager, ConfluenceContentManager confluenceContentManager) {
        this.draftManager = draftManager;
        this.operationService = operationService;
        this.permissionManager = permissionManager;
        this.confluenceSpaceManager = confluenceSpaceManager;
        this.confluenceAccessManager = confluenceAccessManager;
        this.confluenceContentManager = confluenceContentManager;
    }
}

