/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.task;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.rest.task.entity.TaskRestEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;

@AnonymousSiteAccess
@Path(value="/task")
public class TasksResource {
    private final StorageService storageService;
    private final ConfluenceContentManager contentManager;
    private final HandyPermissionService handyPermissionService;

    @Inject
    public TasksResource(StorageService storageService, ConfluenceContentManager contentManager, HandyPermissionService handyPermissionService) {
        this.storageService = storageService;
        this.contentManager = contentManager;
        this.handyPermissionService = handyPermissionService;
    }

    @POST
    @Path(value="/")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response createNewTask(@FormParam(value="contentId") long contentId, @FormParam(value="lastTaskId") int lastTaskId, @FormParam(value="summary") @DefaultValue(value="") String summary) throws XhtmlException, XMLStreamException {
        Content content = this.contentManager.getContent(contentId).orElse(null);
        if (Objects.isNull(content)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(content)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (summary.trim().isEmpty()) {
            return Response.notModified().build();
        }
        int nextTaskId = this.storageService.getNextTaskId(lastTaskId, content);
        String createdTaskMarkup = this.storageService.createNewTaskInContentStorage(lastTaskId, nextTaskId, content, summary);
        TaskRestEntity taskRestEntity = new TaskRestEntity(nextTaskId, createdTaskMarkup);
        return Response.ok((Object)taskRestEntity).build();
    }
}

