/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.statustimestamp;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.stiltsoft.confluence.handy.macros.macro.statustimestamp.StatusTimestampMacroService;
import com.stiltsoft.confluence.handy.macros.rest.statustimestamp.entity.StatusTimestampEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="/status-timestamp")
public class StatusTimestampResource {
    private final StatusTimestampMacroService statusTimestampMacroService;
    private final HandyPermissionService handyPermissionService;

    @Inject
    public StatusTimestampResource(StatusTimestampMacroService statusTimestampMacroService, HandyPermissionService handyPermissionService) {
        this.statusTimestampMacroService = statusTimestampMacroService;
        this.handyPermissionService = handyPermissionService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getStatusTimestamp(@QueryParam(value="statusMacroId") int statusMacroId, @QueryParam(value="format") String format, @QueryParam(value="contentId") Long contentId) {
        if (!this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String lastStatusTimestamp = this.statusTimestampMacroService.getLastStatusTimestamp(statusMacroId, format);
        return Response.ok((Object)new StatusTimestampEntity(lastStatusTimestamp)).build();
    }
}

