/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.status;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroUsageService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetUsageDto;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusSetRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusSetUsageRestEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/status-macro/settings")
public class StatusMacroSettingsResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusMacroSettingsResource.class);
    private final StatusManager statusManager;
    private final StatusesService statusesService;
    private final StatusSetManager statusSetManager;
    private final StatusSetService statusSetService;
    private final HandyPermissionService handyPermissionService;
    private final StatusMacroUsageService statusMacroUsageService;

    @Inject
    public StatusMacroSettingsResource(StatusManager statusManager, StatusesService statusesService, StatusSetManager statusSetManager, StatusSetService statusSetService, HandyPermissionService handyPermissionService, StatusMacroUsageService statusMacroUsageService) {
        this.statusManager = statusManager;
        this.statusesService = statusesService;
        this.statusSetManager = statusSetManager;
        this.statusSetService = statusSetService;
        this.handyPermissionService = handyPermissionService;
        this.statusMacroUsageService = statusMacroUsageService;
    }

    @GET
    @Path(value="/sets")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    public Response getStatusSets(@QueryParam(value="spaceKey") @DefaultValue(value="") String spaceKey, @QueryParam(value="statusSetId") int statusSetId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.hasUseConfluencePermission((User)user) || StringUtils.isEmpty((CharSequence)spaceKey) && !this.handyPermissionService.isConfluenceAdmin((User)user) || StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{spaceKey}) && !this.handyPermissionService.hasCurrentUserSpaceReadPermission(spaceKey)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String personalOwner = "user:" + (user == null ? "" : user.getKey().getStringValue());
        String spaceOwner = "space:" + StringUtils.defaultString((String)spaceKey);
        List<StatusSetRestEntity> statusSetRestEntities = this.statusSetService.getStatusSetRestEntities(statusSetId, "global", spaceOwner, personalOwner);
        return Response.ok(statusSetRestEntities).build();
    }

    @GET
    @Path(value="/sets/{statusSetId}/statuses")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    public Response getSetStatuses(@PathParam(value="statusSetId") int statusSetId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.hasUseConfluencePermission((User)user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List statusRestEntities = this.statusManager.getStatusesBySetId(statusSetId).stream().map(this::toStatusRestEntity).collect(Collectors.toList());
        return Response.ok(statusRestEntities).build();
    }

    @POST
    @Path(value="/sets")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response createStatusSet(@FormParam(value="name") String name, @FormParam(value="owner") @DefaultValue(value="global") String owner) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"To create status set, 'name' is required").build();
        }
        if (!this.handyPermissionService.isOwnerPermitted(owner)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        StatusSetDto statusSet = this.statusesService.createStatusSetAndRefreshCache(name, owner);
        return Response.ok((Object)this.toStatusSetRestEntity(statusSet)).build();
    }

    @DELETE
    @Path(value="/sets/{statusSetId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeStatusSet(@PathParam(value="statusSetId") int statusSetId) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.statusesService.removeStatusSetAndRefreshCache(statusSetId);
        return Response.ok().build();
    }

    @POST
    @Path(value="/sets/{statusSetId}/clone")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response cloneStatusSet(@PathParam(value="statusSetId") int statusSetId) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.hasUseConfluencePermission((User)confluenceUser)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String confluenceUserKey = confluenceUser.getKey().getStringValue();
        return this.statusesService.cloneStatusSetAsPersonalAndRefreshCache(statusSetId, confluenceUserKey).map(statusSet -> Response.ok((Object)this.toStatusSetRestEntity((StatusSetDto)statusSet)).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
    }

    @GET
    @Path(value="/sets/{statusSetId}/usage")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getStatusSetUsageStatistics(@PathParam(value="statusSetId") int statusSetId) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        StatusSetUsageDto usage = this.statusMacroUsageService.getStatusSetUsage(statusSetId);
        return Response.ok((Object)this.toStatusSetUsageRestEntity(usage)).build();
    }

    @PUT
    @Path(value="/sets/{statusSetId}/name")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response renameStatusSet(@PathParam(value="statusSetId") int statusSetId, @FormParam(value="newName") String newName) {
        if (StringUtils.isBlank((CharSequence)newName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"To rename status set, 'newName' is required").build();
        }
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.statusesService.renameStatusSetAndRefreshCache(statusSetId, newName);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/sets/{statusSetId}/view-type")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response changeStatusSetViewType(@PathParam(value="statusSetId") int statusSetId, @FormParam(value="view") @DefaultValue(value="0") int view, @FormParam(value="width") @Nullable Integer width) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.statusesService.changeStatusSetViewTypeAndRefreshCache(statusSetId, view, width);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/sets/{statusSetId}/width")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response categoryWidth(@PathParam(value="statusSetId") int statusSetId, @FormParam(value="width") @DefaultValue(value="0") int width) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.statusesService.changeStatusSetWidthAndRefreshCache(statusSetId, width);
        return Response.ok().build();
    }

    @POST
    @Path(value="/sets/{statusSetId}/statuses")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response createStatus(@PathParam(value="statusSetId") int statusSetId, @FormParam(value="statusName") @DefaultValue(value="") String statusName, @FormParam(value="textColor") @DefaultValue(value="") String textColor, @FormParam(value="backgroundColor") @DefaultValue(value="") String backgroundColor) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (statusName.isEmpty() || backgroundColor.isEmpty()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        StatusDto statusDto = this.statusesService.createStatusAndRefreshCache(statusSetId, statusName, backgroundColor, textColor);
        return Response.ok((Object)this.toStatusRestEntity(statusDto)).build();
    }

    @PUT
    @Path(value="/sets/{statusSetId}/statuses/{statusId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateStatus(@PathParam(value="statusSetId") int statusSetId, @PathParam(value="statusId") int statusId, @FormParam(value="name") @DefaultValue(value="") String statusName, @FormParam(value="textColor") @DefaultValue(value="") String textColor, @FormParam(value="backgroundColor") @DefaultValue(value="") String backgroundColor) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (statusName.isEmpty() || backgroundColor.isEmpty()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        this.statusesService.updateStatusAndRefreshCache(statusId, statusName, backgroundColor, textColor);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/sets/{statusSetId}/statuses/{statusId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response removeStatus(@PathParam(value="statusSetId") int statusSetId, @PathParam(value="statusId") int statusId) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.statusesService.removeStatusAndRefreshCache(statusId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/sets/{statusSetId}/statuses/{statusId}/usage")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getStatusUsageStatistics(@PathParam(value="statusSetId") int statusSetId, @PathParam(value="statusId") int statusId) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        StatusSetUsageDto usage = this.statusMacroUsageService.getStatusUsage(statusSetId, statusId);
        return Response.ok((Object)this.toStatusSetUsageRestEntity(usage)).build();
    }

    @POST
    @Path(value="/sets/{statusSetId}/statuses/order")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response sortStatuses(@PathParam(value="statusSetId") int statusSetId, @FormParam(value="statusIds") List<Integer> statusIds) {
        if (!this.canAdminStatusSet(statusSetId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (statusIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        this.statusManager.sortStatuses(statusSetId, statusIds);
        return Response.ok().build();
    }

    private StatusRestEntity toStatusRestEntity(StatusDto status) {
        return StatusRestEntity.builder().id(status.getId()).name(status.getName()).textColor(status.getTextColor()).backgroundColor(status.getBackgroundColor()).build();
    }

    private StatusSetRestEntity toStatusSetRestEntity(StatusSetDto statusSet) {
        return new StatusSetRestEntity(statusSet.getId(), statusSet.getName(), statusSet.getOwner(), statusSet.getParentId(), null, statusSet.getViewType(), statusSet.getWidth());
    }

    private boolean canAdminStatusSet(int statusSetId) {
        return this.statusSetManager.getStatusSetById(statusSetId).map(StatusSetDto::getOwner).map(this.handyPermissionService::isOwnerPermitted).orElse(Boolean.FALSE);
    }

    private StatusSetUsageRestEntity toStatusSetUsageRestEntity(StatusSetUsageDto usage) {
        Map<Long, String> contentTitleById = usage.getPageById().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AbstractPage)entry.getValue()).getTitle()));
        return new StatusSetUsageRestEntity(contentTitleById, usage.getRestrictedPagesCount());
    }
}

