/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.status;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroHistoryService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusChangeRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusMacroRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.history.StatusHistoryChangeRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.option.DropdownSectionRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.option.StatusDropdownItemRestEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Path(value="/status-macro")
public class StatusMacroResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusMacroResource.class);
    private final LicenseManager licenseManager;
    private final StatusesService statusesService;
    private final StatusSetManager statusSetManager;
    private final StatusSetService statusSetService;
    private final StatusMacroManager statusMacroManager;
    private final StatusMacroService statusMacroService;
    private final ConfluenceContentManager contentManager;
    private final HandyPermissionService handyPermissionService;
    private final StatusMacroHistoryService statusMacroHistoryService;

    @Inject
    public StatusMacroResource(LicenseManager licenseManager, StatusesService statusesService, StatusSetManager statusSetManager, StatusSetService statusSetService, StatusMacroManager statusMacroManager, StatusMacroService statusMacroService, ConfluenceContentManager contentManager, HandyPermissionService handyPermissionService, StatusMacroHistoryService statusMacroHistoryService) {
        this.licenseManager = licenseManager;
        this.statusesService = statusesService;
        this.statusSetManager = statusSetManager;
        this.statusSetService = statusSetService;
        this.statusMacroManager = statusMacroManager;
        this.statusMacroService = statusMacroService;
        this.contentManager = contentManager;
        this.handyPermissionService = handyPermissionService;
        this.statusMacroHistoryService = statusMacroHistoryService;
    }

    @POST
    @Path(value="/")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response createStatusMacro(@FormParam(value="contentId") @Nullable Long contentId, @FormParam(value="spaceKey") String spaceKey) {
        contentId = contentId == null || contentId == 0L ? null : contentId;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(contentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String userKey = Objects.nonNull(user) ? user.getKey().getStringValue() : null;
        Optional<StatusDto> firstAvailableStatusOptional = this.statusSetService.getFirstAvailableStatus(spaceKey, userKey);
        if (!firstAvailableStatusOptional.isPresent()) {
            return Response.ok().build();
        }
        StatusDto status = firstAvailableStatusOptional.get();
        StatusSetDto statusSet = this.statusesService.getStatusSetFromCacheOrDB(status.getStatusSetId()).get();
        int statusId = status.getId();
        int statusSetId = statusSet.getId();
        StatusMacroDto statusMacro = this.statusMacroService.createStatusMacroAndCache(statusSetId, statusId, Boolean.FALSE, contentId, false, "", true);
        int statusMacroId = statusMacro.getId();
        int width = statusSet.getWidthOrDefault();
        StatusMacroRestEntity responseEntity = StatusMacroRestEntity.builder().id(statusMacroId).set(statusSetId).status(statusId).outline(false).licensed(this.licenseManager.isActive()).labelled(false).prefix("").width(width).build();
        return Response.ok((Object)responseEntity).build();
    }

    @GET
    @Path(value="/{macroId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getStatusMacro(@PathParam(value="macroId") int macroId, @QueryParam(value="contentId") @Nullable Long contentIdParam) {
        Long contentId = contentIdParam == null || contentIdParam == 0L ? null : contentIdParam;
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrCreateDraftCopyAndCache(macroId, contentId);
        if (!statusMacroOptional.isPresent()) {
            log.warn("Cannot get entity (get-macro) macroId={}, contentId={}", (Object)macroId, (Object)contentId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        Optional<Long> actualContentIdOptional = statusMacro.getConfluencePageId();
        if (actualContentIdOptional.isPresent() && !this.handyPermissionService.hasCurrentUserContentReadPermission(actualContentIdOptional.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        int statusSetId = statusMacro.getStatusSetId();
        boolean isLicensed = this.licenseManager.isActive();
        int width = this.statusSetManager.getStatusSetWidthOrDefault(statusSetId);
        StatusMacroRestEntity restEntity = this.toStatusMacroRestEntity(statusMacro, width, isLicensed);
        return Response.ok((Object)restEntity).build();
    }

    @PUT
    @Path(value="/{macroId}/value")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response changeStatus(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") long contentId, @FormParam(value="statusId") int statusId, @FormParam(value="name") String statusName) {
        Content content = this.getContent(contentId);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(content)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.statusMacroService.changeStatusIdForStatusMacroAndRefreshCache(macroId, statusId, contentId, user).map(newMacroId -> {
            int pageVersion = this.statusMacroService.updateMacroParamsInContentStorageMarkup(contentId, content, macroId, (int)newMacroId, statusName);
            return new StatusChangeRestEntity((Integer)newMacroId, pageVersion);
        }).map(restEntity -> Response.ok((Object)restEntity).build()).orElseGet(() -> {
            log.warn("Cannot change status. ContentId={}, macroId={}, statusId={}, statusName={}.", new Object[]{contentId, macroId, statusId, statusName});
            return Response.notModified().build();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="/{macroId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateStatusMacro(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") @Nullable Long contentId, @FormParam(value="statusId") long statusId, @FormParam(value="statusSetId") int statusSetId, @FormParam(value="outline") @DefaultValue(value="false") boolean outline, @FormParam(value="labelled") @DefaultValue(value="false") boolean labelled, @FormParam(value="prefix") @DefaultValue(value="") String labelPrefix) {
        Long l = contentId = contentId == null || contentId == 0L ? null : contentId;
        if (contentId == null) {
            Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrFindWithMapping(macroId, null);
            if (statusMacroOptional.isPresent()) {
                StatusMacroDto statusMacro = statusMacroOptional.get();
                if (!statusMacro.getConfluencePageId().isPresent()) return this.statusMacroService.updateStatusMacroAndRefreshCache(macroId, statusSetId, statusId, outline, labelled, labelPrefix, contentId).map(newMacroId -> Response.ok((Object)newMacroId).build()).orElseGet(() -> Response.notModified().build());
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            log.warn("Cannot get entity for updating status macro. macroId={}, statusId={}, setId={}", new Object[]{macroId, statusId, statusSetId});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.handyPermissionService.hasCurrentUserContentEditPermission(contentId)) return this.statusMacroService.updateStatusMacroAndRefreshCache(macroId, statusSetId, statusId, outline, labelled, labelPrefix, contentId).map(newMacroId -> Response.ok((Object)newMacroId).build()).orElseGet(() -> Response.notModified().build());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="/{macroId}/clone")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response cloneStatusMacro(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") @Nullable Long contentId) {
        contentId = contentId == null || contentId == 0L ? null : contentId;
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrCreateDraftCopyAndCache(macroId, null);
        if (!statusMacroOptional.isPresent()) {
            log.warn("Cannot get entity for cloning macro. statusMacroId={}, contentId={}", (Object)macroId, (Object)contentId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        if (statusMacro.getConfluencePageId().isPresent() && this.contentManager.isContentPresent(statusMacro.getConfluencePageId().get()) && !this.handyPermissionService.hasCurrentUserContentEditPermission(statusMacro.getConfluencePageId().get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        StatusMacroDto clonedStatusMacro = this.statusMacroService.createStatusMacroAndCache(statusMacro.getStatusSetId(), statusMacro.getStatusId(), statusMacro.isOutline(), contentId, statusMacro.isLabeled(), statusMacro.getLabelPrefix(), true);
        int clonedStatusMacroId = clonedStatusMacro.getId();
        return Response.ok((Object)clonedStatusMacroId).build();
    }

    @POST
    @Path(value="/{macroId}/draft")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response createStatusMacroDraft(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") @Nullable Long contentId, @FormParam(value="statusId") long statusId, @FormParam(value="statusSetId") int statusSetId, @FormParam(value="outline") @DefaultValue(value="false") boolean outline, @FormParam(value="labelled") @DefaultValue(value="false") boolean labelled, @FormParam(value="prefix") @DefaultValue(value="") String labelPrefix) {
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrFindWithMapping(macroId, contentId = contentId == null || contentId == 0L ? null : contentId);
        if (!statusMacroOptional.isPresent()) {
            log.warn("Cannot get entity for creating draft macro. statusMacroId={}, contentId={}", (Object)macroId, (Object)contentId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        Long originalContentId = statusMacro.getConfluencePageId().get();
        if (statusMacro.getConfluencePageId().isPresent() && !this.handyPermissionService.hasCurrentUserContentEditPermission(originalContentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        StatusMacroDto draftStatusMacro = this.statusMacroManager.createDraftStatusMacro(statusMacro.getId(), statusSetId, statusId, outline, contentId, labelled, labelPrefix);
        return Response.ok((Object)draftStatusMacro.getId()).build();
    }

    @GET
    @Path(value="/{macroId}/history")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getStatusHistory(@PathParam(value="macroId") int macroId, @QueryParam(value="contentId") @Nullable Long contentId) {
        contentId = contentId == null || contentId == 0L ? null : contentId;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrFindWithMapping(macroId, contentId);
        if (!statusMacroOptional.isPresent()) {
            log.warn("Cannot find entity for getting status history. macroId={}, contentId={}", (Object)macroId, (Object)contentId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        if (statusMacro.getConfluencePageId().isPresent() && !this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<StatusHistoryChangeRestEntity> restEntities = this.statusMacroHistoryService.getStatusHistoryChangeRestEntities(user, statusMacro);
        return Response.ok(restEntities).build();
    }

    @GET
    @Path(value="/{macroId}/options")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getStatusDropdownOptions(@PathParam(value="macroId") int macroId, @QueryParam(value="contentId") @Nullable Long contentId, @QueryParam(value="limit") @DefaultValue(value="15") int limit, @QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="searchInput") @DefaultValue(value="false") boolean searchInput) {
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroService.getCachedStatusMacroOrFindWithMapping(macroId, contentId);
        if (!statusMacroOptional.isPresent()) {
            log.warn("Cannot find a status macro for getting options. macroId={}, contentId={}, query={}, limit={}", new Object[]{macroId, contentId, query, limit});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        if (statusMacro.getConfluencePageId().isPresent() && !this.handyPermissionService.hasCurrentUserContentReadPermission(statusMacro.getConfluencePageId().get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<StatusDropdownItemRestEntity> dropdownItems = this.statusMacroService.getStatusDropdownItemRestEntities(statusMacro, macroId, limit, query, searchInput);
        return Response.ok(Collections.singletonList(new DropdownSectionRestEntity<StatusDropdownItemRestEntity>(dropdownItems))).build();
    }

    @Nullable
    private Content getContent(@Nullable Long contentId) {
        return Optional.ofNullable(contentId).flatMap(this.contentManager::getContent).orElse(null);
    }

    private StatusMacroRestEntity toStatusMacroRestEntity(StatusMacroDto statusMacro, int statusWidth, boolean isLicensed) {
        return StatusMacroRestEntity.builder().id(statusMacro.getId()).set(statusMacro.getStatusSetId()).status(statusMacro.extractStatusId()).outline(statusMacro.isOutline()).licensed(isLicensed).labelled(statusMacro.isLabeled()).prefix(statusMacro.getLabelPrefix()).width(statusWidth).build();
    }
}

