/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.reminder;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.ReminderMacroService;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ReminderMacroParams;
import com.stiltsoft.confluence.handy.macros.macro.reminder.mail.MailSender;
import com.stiltsoft.confluence.handy.macros.rest.reminder.entity.ReminderMacroRestEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.storage.HandyWikiStyleRenderer;
import com.stiltsoft.confluence.handy.macros.util.AuthenticatedUserUtil;
import com.stiltsoft.confluence.handy.macros.util.ServiceResult;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reminder-macro")
public class ReminderMacroResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReminderMacroResource.class);
    private final MailSender mailSender;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final LicenseManager licenseManager;
    private final HandyWikiStyleRenderer wikiStyleRenderer;
    private final ReminderMacroService reminderMacroService;
    private final HandyPermissionService handyPermissionService;

    @Inject
    public ReminderMacroResource(MailSender mailSender, PageManager pageManager, SpaceManager spaceManager, LicenseManager licenseManager, HandyWikiStyleRenderer wikiStyleRenderer, ReminderMacroService reminderMacroService, HandyPermissionService handyPermissionService) {
        this.mailSender = mailSender;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.licenseManager = licenseManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.reminderMacroService = reminderMacroService;
        this.handyPermissionService = handyPermissionService;
    }

    @POST
    @Path(value="/")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response createMacro(@FormParam(value="contentId") @Nullable Long contentId, @FormParam(value="users") Set<String> users, @FormParam(value="groups") Set<String> groups, @FormParam(value="date") long date, @FormParam(value="type") int type, @FormParam(value="desc") String desc, @FormParam(value="paused") boolean paused, @FormParam(value="showDesc") boolean showDesc, @FormParam(value="showDate") boolean showDate, @FormParam(value="dayOfWeek") @Nullable Integer dayOfWeek, @FormParam(value="dayNumber") @Nullable Integer dayNumber) {
        Long pageId = contentId == null || contentId == 0L ? null : contentId;
        ServiceResult<ReminderMacroParams> result = this.reminderMacroService.validateAndCreateReminderMacroParams(pageId, users, groups, date, type, desc, paused, showDesc, showDate, dayOfWeek, dayNumber);
        if (result.hasError()) {
            log.error("Cannot create macro. ContentId = {}, reason = {}", (Object)contentId, (Object)result.getErrorMessage());
            if (result.getErrorMessage().contains("license")) {
                return Response.ok((Object)false).build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)result.get().getId()).build();
    }

    @GET
    @Path(value="/{macroId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getMacro(@PathParam(value="macroId") int macroId, @QueryParam(value="contentId") @Nullable Long contentId) {
        Long pageId = contentId == null || contentId == 0L ? null : contentId;
        ServiceResult<ReminderMacroRestEntity> result = this.reminderMacroService.validateAndGetReminderMacroOrCopy(macroId, pageId);
        if (result.hasError()) {
            log.error("Cannot get macro. MacroId = {}, ContentId = {}, reason = {}", new Object[]{macroId, pageId, result.getErrorMessage()});
            if (result.getErrorMessage().contains("license")) {
                return Response.ok((Object)new ReminderMacroRestEntity(false)).build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)result.get()).build();
    }

    @PUT
    @Path(value="/{macroId}")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updateMacro(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") @Nullable Long contentId, @FormParam(value="users") Set<String> userKeys, @FormParam(value="groups") Set<String> groupNames, @FormParam(value="date") long date, @FormParam(value="lastDate") Long lastDate, @FormParam(value="type") int type, @FormParam(value="amount") int amount, @FormParam(value="desc") String desc, @FormParam(value="paused") boolean paused, @FormParam(value="showDesc") boolean showDesc, @FormParam(value="showDate") boolean showDate, @FormParam(value="dayOfWeek") @Nullable Integer dayOfWeek, @FormParam(value="dayNumber") @Nullable Integer dayNumber) {
        ServiceResult<Boolean> result = this.reminderMacroService.validateAndUpdateReminderMacro(contentId, macroId, userKeys, groupNames, date, lastDate, type, desc, paused, showDesc, showDate, amount, dayOfWeek, dayNumber);
        if (result.hasError()) {
            log.error("Cannot update macro. MacroId = {}, ContentId = {}, reason = {}", new Object[]{macroId, contentId, result.getErrorMessage()});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{macroId}/next-date")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response updatedNextDate(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") long contentId, @FormParam(value="date") long nextDate) {
        ServiceResult<Boolean> result = this.reminderMacroService.validateAndUpdateNextDateAndPaused(macroId, contentId, nextDate);
        if (result.hasError()) {
            log.error("Cannot set next date. MacroId = {}, ContentId = {}, reason = {}", new Object[]{macroId, contentId, result.getErrorMessage()});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/{macroId}/clone")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response cloneMacro(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") @Nullable Long contentId) {
        Long pageId = contentId == null || contentId == 0L ? null : contentId;
        ServiceResult<ReminderMacroParams> result = this.reminderMacroService.validateAndCloneReminderMacro(macroId, pageId);
        if (result.hasError()) {
            log.error("Cannot clone Reminder Macro. MacroId = {}, ContentId = {}, reason = {}", new Object[]{macroId, pageId, result.getErrorMessage()});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)result.get().getId()).build();
    }

    @POST
    @Path(value="/{macroId}/test-mail")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response testMail(@PathParam(value="macroId") int macroId, @FormParam(value="contentId") @Nullable Long contentId, @FormParam(value="text") String textWiki, @FormParam(value="title") String title, @FormParam(value="spaceKey") String spaceKey) throws Exception {
        Optional<ConfluenceUser> authenticatedUser = AuthenticatedUserUtil.getAuthenticatedUser();
        if (!authenticatedUser.isPresent() || !this.licenseManager.isActive()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ConfluenceUser user = authenticatedUser.get();
        AbstractPage page = Optional.ofNullable(contentId).map(arg_0 -> ((PageManager)this.pageManager).getAbstractPage(arg_0)).orElse(null);
        if (page == null) {
            if (!this.handyPermissionService.hasCurrentUserSpaceReadPermission(spaceKey)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Space space = this.spaceManager.getSpace(spaceKey);
            page = new Page();
            page.setId(contentId == null ? 0L : contentId);
            page.setTitle(title);
            page.setSpace(space);
        } else if (!this.handyPermissionService.hasEntityEditPermission((User)user, (ContentEntityObject)page)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String textHtml = this.wikiStyleRenderer.convertWikiToXHtml(textWiki);
        this.mailSender.send(page, user, user, textHtml, macroId);
        return Response.ok().build();
    }
}

