/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.pagestatus;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.PageStatusHistoryService;
import com.stiltsoft.confluence.handy.macros.pagestatus.PageStatusService;
import com.stiltsoft.confluence.handy.macros.pagestatus.dto.PageStatusDto;
import com.stiltsoft.confluence.handy.macros.pagestatus.dto.PageStatusEditorDto;
import com.stiltsoft.confluence.handy.macros.rest.pagestatus.entity.history.PageStatusHistoryRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.view.ViewRestEntityUtil;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Path(value="/page")
public class PageStatusResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageStatusResource.class);
    private final PageStatusService pageStatusService;
    private final PageStatusHistoryService pageStatusHistoryService;
    private final HandyPermissionService handyPermissionService;
    private final ConfluenceContentManager contentManager;

    @Inject
    public PageStatusResource(PageStatusService pageStatusService, PageStatusHistoryService pageStatusHistoryService, HandyPermissionService handyPermissionService, ConfluenceContentManager contentManager) {
        this.pageStatusService = pageStatusService;
        this.pageStatusHistoryService = pageStatusHistoryService;
        this.handyPermissionService = handyPermissionService;
        this.contentManager = contentManager;
    }

    @GET
    @Path(value="/{contentId}/status")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getPageStatus(@PathParam(value="contentId") long contentId) {
        if (!this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            log.warn("User does not have permission to read content (get-page-status), contentId={}", (Object)contentId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No permission to read content").build();
        }
        PageStatusDto pageStatus = this.pageStatusService.getPageStatusOrEmpty(contentId);
        return Response.ok((Object)ViewRestEntityUtil.toPageStatusRestEntity(pageStatus)).build();
    }

    @GET
    @Path(value="/{contentId}/status/editor")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getPageStatusForEditor(@PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") @DefaultValue(value="") String spaceKey) {
        if (!this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            log.warn("User does not have permission to read content (get-page-status-editor), contentId={}", (Object)contentId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No permission to read content").build();
        }
        PageStatusEditorDto pageStatusEditor = this.pageStatusService.getPageStatusForEditorOrEmpty(contentId, spaceKey);
        return Response.ok((Object)ViewRestEntityUtil.toPageStatusEditorRestEntity(pageStatusEditor)).build();
    }

    @POST
    @Path(value="/{contentId}/status/editor")
    @XsrfProtectionExcluded
    public Response addPageStatus(@PathParam(value="contentId") long contentId, @FormParam(value="statusId") int statusId, @FormParam(value="statusSetId") int statusSetId) {
        Content content = this.getContent(contentId);
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(content)) {
            log.warn("User does not have permission to edit content (add-page-status-editor), contentId={}.", (Object)contentId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No permission to edit content").build();
        }
        try {
            this.pageStatusService.addPageStatusForContent(content, statusId, statusSetId);
            return Response.ok((Object)"Page status added").build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (ConflictException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (BadRequestException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (RuntimeException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/{contentId}/status/editor")
    @XsrfProtectionExcluded
    public Response updatePageStatus(@PathParam(value="contentId") long contentId, @FormParam(value="statusId") int statusId, @FormParam(value="statusSetId") int statusSetId) {
        Content content = this.getContent(contentId);
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(content)) {
            log.warn("User does not have permission to edit content (put-page-status-editor), contentId={}.", (Object)contentId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No permission to edit content").build();
        }
        try {
            this.pageStatusService.updatePageStatusForContent(content, statusId, statusSetId);
            return Response.ok().entity((Object)"Page status updated").build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (BadRequestException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (RuntimeException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/{contentId}/status/editor")
    @XsrfProtectionExcluded
    public Response deletePageStatus(@PathParam(value="contentId") long contentId) {
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(contentId)) {
            log.warn("User does not have permission to edit content (delete-page-status-editor), contentId={}.", (Object)contentId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No permission to edit content").build();
        }
        try {
            this.pageStatusService.deletePageStatusForContent(contentId);
            return Response.noContent().entity((Object)"Page status deleted").build();
        }
        catch (RuntimeException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{contentId}/status/history")
    @Produces(value={"application/json"})
    public Response getPageStatusHistory(@PathParam(value="contentId") long contentId) {
        if (!this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            log.warn("User does not have permission to read content (get-page-status-history), contentId={}", (Object)contentId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No permission to read content").build();
        }
        List<PageStatusHistoryRestEntity> pageStatusHistoryRestEntities = this.pageStatusHistoryService.getPageStatusHistoryRestEntities(contentId);
        return Response.ok(pageStatusHistoryRestEntities).build();
    }

    @Nullable
    private Content getContent(@Nullable Long contentId) {
        return Optional.ofNullable(contentId).flatMap(this.contentManager::getContent).orElse(null);
    }
}

