/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.diff;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffManager;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffService;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.util.AuthenticatedUserUtil;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/diff")
public class PageDiffResource {
    private final PageDiffManager pageDiffManager;
    private final PageDiffService pageDiffService;
    private final HandyPermissionService handyPermissionService;

    @Inject
    public PageDiffResource(PageDiffManager pageDiffManager, PageDiffService pageDiffService, HandyPermissionService handyPermissionService) {
        this.pageDiffManager = pageDiffManager;
        this.pageDiffService = pageDiffService;
        this.handyPermissionService = handyPermissionService;
    }

    @PUT
    @Path(value="/")
    @ReadOnlyAccessAllowed
    @XsrfProtectionExcluded
    public Response setPageVersionAsBeenViewed(@FormParam(value="version") int version, @FormParam(value="contentId") long contentId) {
        Optional<String> authenticatedUserKey = AuthenticatedUserUtil.getAuthenticatedUserKey();
        if (!authenticatedUserKey.isPresent() || !this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.pageDiffManager.setVersion(contentId, authenticatedUserKey.get(), version);
        return Response.ok().build();
    }

    @GET
    @Path(value="/version")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getLastViewedPageVersion(@QueryParam(value="contentId") long contentId) {
        Optional<String> authenticatedUserKey = AuthenticatedUserUtil.getAuthenticatedUserKey();
        if (!authenticatedUserKey.isPresent() || !this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        int version = this.pageDiffManager.getVersion(contentId, authenticatedUserKey.get());
        return Response.ok((Object)version).build();
    }

    @GET
    @Path(value="/contributors")
    @XsrfProtectionExcluded
    @Produces(value={"application/json"})
    public Response getPageContributors(@QueryParam(value="version") int version, @QueryParam(value="contentId") long contentId) {
        if (!this.handyPermissionService.hasCurrentUserContentReadPermission(contentId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok(this.pageDiffService.getPageContributors(contentId, version)).build();
    }
}

