/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.analytics.entity;

import com.stiltsoft.confluence.handy.macros.tracking.DeploymentType;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class CommonDimensionsRestEntity {
    private static final String NONE = "NONE";
    @XmlElement
    private String serverHash;
    @XmlElement
    private String userHash;
    @XmlElement
    private String licenseTier;
    @XmlElement
    private String pluginVersion;
    @XmlElement
    private String licenseType;
    @XmlElement
    private String deploymentType;
    @XmlElement
    private int remindersNumber;
    @XmlElement
    private long remindersNumberLastSendDate;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String serverHash = "";
        private String userHash = "";
        private String licenseTier = "NONE";
        private String pluginVersion = "";
        private String licenseType = "";
        private DeploymentType deploymentType;
        private int remindersNumber;
        private long remindersNumberLastSendDate;

        public Builder serverHash(String serverHash) {
            this.serverHash = serverHash;
            return this;
        }

        public Builder userHash(String userHash) {
            this.userHash = userHash;
            return this;
        }

        public Builder userCount(Integer userCount) {
            this.licenseTier = Optional.ofNullable(userCount).map(value -> value == -1 ? "Unlimited" : String.valueOf(value)).orElse(CommonDimensionsRestEntity.NONE);
            return this;
        }

        public Builder pluginVersion(String pluginVersion) {
            this.pluginVersion = pluginVersion;
            return this;
        }

        public Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        public Builder remindersNumber(int remindersNumber) {
            this.remindersNumber = remindersNumber;
            return this;
        }

        public Builder remindersNumberLastSendDate(long remindersNumberLastSendDate) {
            this.remindersNumberLastSendDate = remindersNumberLastSendDate;
            return this;
        }

        public CommonDimensionsRestEntity build() {
            CommonDimensionsRestEntity r = new CommonDimensionsRestEntity();
            r.serverHash = this.serverHash;
            r.userHash = this.userHash;
            r.licenseTier = this.licenseTier;
            r.pluginVersion = this.pluginVersion;
            r.licenseType = this.licenseType;
            r.deploymentType = this.deploymentType.name();
            r.remindersNumber = this.remindersNumber;
            r.remindersNumberLastSendDate = this.remindersNumberLastSendDate;
            return r;
        }
    }
}

