/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest.analytics;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.rest.analytics.entity.RemindersNumberLastSendDateEntity;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.tracking.TrackingService;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/analytics")
public class AnalyticsResource {
    private final TrackingService trackingService;
    private final HandyPermissionService handyPermissionService;

    @Inject
    public AnalyticsResource(TrackingService trackingService, HandyPermissionService handyPermissionService) {
        this.trackingService = trackingService;
        this.handyPermissionService = handyPermissionService;
    }

    @GET
    @Path(value="/")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    public Response getGAState() {
        return this.trackingService.getTrackingConsent().map(Response::ok).orElseGet(Response::noContent).build();
    }

    @PUT
    @Path(value="/")
    public Response allowTracking() {
        if (!this.handyPermissionService.isConfluenceAdmin((User)AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.trackingService.allowTracking();
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/")
    public Response disableTracking() {
        if (!this.handyPermissionService.isConfluenceAdmin((User)AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.trackingService.disableTracking();
        return Response.ok().build();
    }

    @GET
    @AnonymousSiteAccess
    @Path(value="/dimensions")
    @Produces(value={"application/json"})
    public Response getCommonDimensions() {
        return Response.ok((Object)this.trackingService.getCommonDimensionsRestEntity()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/reminder-send-date")
    public Response updateRemindersNumberLastSendDate(RemindersNumberLastSendDateEntity lastSendDateEntity) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.hasUseConfluencePermission((User)user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.trackingService.updateRemindersLastSendDate(lastSendDateEntity.remindersNumberLastSendDate);
        return Response.ok().build();
    }
}

