/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.stiltsoft.confluence.handy.macros.diff.PageDiffSettingsManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.PageStatusSettingsManager;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.settings.HandyHeaderSettingsService;
import com.stiltsoft.confluence.handy.macros.settings.HandyTasksSettingsService;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/settings")
public class SettingsResource {
    private final HandyPermissionService handyPermissionService;
    private final PageDiffSettingsManager pageDiffSettingsManager;
    private final HandyTasksSettingsService handyTasksSettingsService;
    private final HandyHeaderSettingsService handyHeaderSettingsService;
    private final PageStatusSettingsManager pageStatusSettingsManager;

    @Inject
    public SettingsResource(HandyPermissionService handyPermissionService, PageDiffSettingsManager pageDiffSettingsManager, HandyTasksSettingsService handyTasksSettingsService, HandyHeaderSettingsService handyHeaderSettingsService, PageStatusSettingsManager pageStatusSettingsManager) {
        this.handyPermissionService = handyPermissionService;
        this.pageDiffSettingsManager = pageDiffSettingsManager;
        this.handyTasksSettingsService = handyTasksSettingsService;
        this.handyHeaderSettingsService = handyHeaderSettingsService;
        this.pageStatusSettingsManager = pageStatusSettingsManager;
    }

    @POST
    @Path(value="/handy-diff")
    @XsrfProtectionExcluded
    public Response setHandyDiff(@FormParam(value="owner") String owner, @FormParam(value="enabled") boolean enabled) {
        if (!this.handyPermissionService.isOwnerPermitted(owner)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.pageDiffSettingsManager.setEnabled(owner, enabled);
        return Response.ok().build();
    }

    @POST
    @Path(value="/handy-header")
    @XsrfProtectionExcluded
    public Response setHandyHeader(@FormParam(value="owner") String owner, @FormParam(value="enabled") boolean enabled) {
        if (!this.handyPermissionService.isOwnerPermitted(owner)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.handyHeaderSettingsService.setEnabled(owner, enabled);
        return Response.ok().build();
    }

    @POST
    @Path(value="/handy-tasks")
    @XsrfProtectionExcluded
    public Response setHandyTasks(@FormParam(value="owner") String owner, @FormParam(value="enabled") boolean enabled) {
        if (!this.handyPermissionService.isOwnerPermitted(owner)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.handyTasksSettingsService.setEnabled(owner, enabled);
        return Response.ok().build();
    }

    @POST
    @Path(value="/handy-page-status")
    @XsrfProtectionExcluded
    public Response setPageStatus(@FormParam(value="enabled") boolean enabled) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.handyPermissionService.isConfluenceAdmin((User)user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.pageStatusSettingsManager.setPageStatusEnabled(enabled);
        return Response.ok().build();
    }
}

