/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.util.ServiceResult;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;

@AnonymousSiteAccess
@Path(value="/date")
public class DateResource {
    private final StorageService storageService;
    private final ConfluenceContentManager contentManager;
    private final HandyPermissionService handyPermissionService;

    @Inject
    public DateResource(StorageService storageService, ConfluenceContentManager contentManager, HandyPermissionService handyPermissionService) {
        this.storageService = storageService;
        this.contentManager = contentManager;
        this.handyPermissionService = handyPermissionService;
    }

    @PUT
    @Path(value="/")
    @XsrfProtectionExcluded
    public Response updateDate(@FormParam(value="contentId") long contentId, @FormParam(value="pageVersion") int pageVersion, @FormParam(value="elementId") int elementId, @FormParam(value="date") @DefaultValue(value="") String date) throws XMLStreamException {
        if (date.isEmpty()) {
            return Response.notModified().build();
        }
        Optional<Content> latestContentOptional = this.contentManager.getContent(contentId);
        Optional<Content> actualContentOptional = this.contentManager.getContent(contentId, pageVersion);
        if (!latestContentOptional.isPresent() || !actualContentOptional.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Content latestContent = latestContentOptional.get();
        Content actualContent = actualContentOptional.get();
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(latestContent)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ServiceResult<Boolean> result = this.storageService.updateDate(latestContent, actualContent, elementId, date);
        return result.hasError() ? Response.serverError().entity((Object)result.getErrorMessage()).build() : Response.ok().build();
    }

    @PUT
    @Path(value="/ppr")
    @XsrfProtectionExcluded
    public Response updatePPRDate(@FormParam(value="contentId") long contentId, @FormParam(value="elementId") int elementId, @FormParam(value="date") String date, @FormParam(value="colName") String colName) {
        Optional<Content> contentOptional = this.contentManager.getContent(contentId);
        if (!contentOptional.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Content content = contentOptional.get();
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(content)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.storageService.updatePPRBody(content, elementId, date, colName);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/task")
    @XsrfProtectionExcluded
    public Response updateTaskDate(@FormParam(value="contentId") long contentId, @FormParam(value="taskId") int taskId, @FormParam(value="elementId") int elementId, @FormParam(value="date") @DefaultValue(value="") String date) throws XMLStreamException {
        if (date.isEmpty()) {
            return Response.notModified().build();
        }
        Optional<Content> contentOptional = this.contentManager.getContent(contentId);
        if (!contentOptional.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Content content = contentOptional.get();
        if (!this.handyPermissionService.hasCurrentUserContentEditPermission(content)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.storageService.updateTaskDate(content, taskId, elementId, date);
        return Response.ok().build();
    }
}

