/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.pagestatus.property.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusHistoryChange;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PageStatusHistoryProperty {
    @JsonProperty
    private final String author;
    @JsonProperty
    private final Set<String> authorUserKeys;
    @JsonProperty
    private final Set<String> authorAccountIds;
    @JsonProperty
    private final String lastChangeTimestamp;
    @JsonProperty
    private final String lastChangeTimestampDate;
    @JsonProperty
    private final List<PageStatusHistoryChange> changes;

    @JsonCreator
    private PageStatusHistoryProperty() {
        this(PageStatusHistoryProperty.builder());
    }

    PageStatusHistoryProperty(PageStatusHistoryPropertyBuilder builder) {
        this.author = builder.author;
        this.authorUserKeys = builder.authorUserKeys;
        this.authorAccountIds = builder.authorAccountIds;
        this.lastChangeTimestamp = builder.lastChangeTimestamp;
        this.changes = builder.changes;
        this.lastChangeTimestampDate = builder.lastChangeTimestampDate;
    }

    @JsonIgnore
    public long getLastChangeTimestampAsLong() {
        return Long.parseLong(this.lastChangeTimestamp);
    }

    public static PageStatusHistoryPropertyBuilder builder() {
        return new PageStatusHistoryPropertyBuilder();
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public Set<String> getAuthorUserKeys() {
        return this.authorUserKeys;
    }

    @Generated
    public Set<String> getAuthorAccountIds() {
        return this.authorAccountIds;
    }

    @Generated
    public String getLastChangeTimestamp() {
        return this.lastChangeTimestamp;
    }

    @Generated
    public String getLastChangeTimestampDate() {
        return this.lastChangeTimestampDate;
    }

    @Generated
    public List<PageStatusHistoryChange> getChanges() {
        return this.changes;
    }

    @Generated
    public String toString() {
        return "PageStatusHistoryProperty(author=" + this.getAuthor() + ", authorUserKeys=" + this.getAuthorUserKeys() + ", authorAccountIds=" + this.getAuthorAccountIds() + ", lastChangeTimestamp=" + this.getLastChangeTimestamp() + ", lastChangeTimestampDate=" + this.getLastChangeTimestampDate() + ", changes=" + this.getChanges() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageStatusHistoryProperty)) {
            return false;
        }
        PageStatusHistoryProperty other = (PageStatusHistoryProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        Set<String> this$authorUserKeys = this.getAuthorUserKeys();
        Set<String> other$authorUserKeys = other.getAuthorUserKeys();
        if (this$authorUserKeys == null ? other$authorUserKeys != null : !((Object)this$authorUserKeys).equals(other$authorUserKeys)) {
            return false;
        }
        Set<String> this$authorAccountIds = this.getAuthorAccountIds();
        Set<String> other$authorAccountIds = other.getAuthorAccountIds();
        if (this$authorAccountIds == null ? other$authorAccountIds != null : !((Object)this$authorAccountIds).equals(other$authorAccountIds)) {
            return false;
        }
        String this$lastChangeTimestamp = this.getLastChangeTimestamp();
        String other$lastChangeTimestamp = other.getLastChangeTimestamp();
        if (this$lastChangeTimestamp == null ? other$lastChangeTimestamp != null : !this$lastChangeTimestamp.equals(other$lastChangeTimestamp)) {
            return false;
        }
        String this$lastChangeTimestampDate = this.getLastChangeTimestampDate();
        String other$lastChangeTimestampDate = other.getLastChangeTimestampDate();
        if (this$lastChangeTimestampDate == null ? other$lastChangeTimestampDate != null : !this$lastChangeTimestampDate.equals(other$lastChangeTimestampDate)) {
            return false;
        }
        List<PageStatusHistoryChange> this$changes = this.getChanges();
        List<PageStatusHistoryChange> other$changes = other.getChanges();
        return !(this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageStatusHistoryProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        Set<String> $authorUserKeys = this.getAuthorUserKeys();
        result = result * 59 + ($authorUserKeys == null ? 43 : ((Object)$authorUserKeys).hashCode());
        Set<String> $authorAccountIds = this.getAuthorAccountIds();
        result = result * 59 + ($authorAccountIds == null ? 43 : ((Object)$authorAccountIds).hashCode());
        String $lastChangeTimestamp = this.getLastChangeTimestamp();
        result = result * 59 + ($lastChangeTimestamp == null ? 43 : $lastChangeTimestamp.hashCode());
        String $lastChangeTimestampDate = this.getLastChangeTimestampDate();
        result = result * 59 + ($lastChangeTimestampDate == null ? 43 : $lastChangeTimestampDate.hashCode());
        List<PageStatusHistoryChange> $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
        return result;
    }

    public static class PageStatusHistoryPropertyBuilder {
        private String author = "";
        private Set<String> authorUserKeys = new HashSet<String>();
        private Set<String> authorAccountIds = new HashSet<String>();
        private String lastChangeTimestamp = "";
        private String lastChangeTimestampDate = "";
        private List<PageStatusHistoryChange> changes = new ArrayList<PageStatusHistoryChange>();

        PageStatusHistoryPropertyBuilder() {
        }

        public PageStatusHistoryPropertyBuilder author(String author) {
            this.author = author;
            return this;
        }

        public PageStatusHistoryPropertyBuilder authorUserKeys(Set<String> authorUserKeys) {
            this.authorUserKeys = authorUserKeys;
            return this;
        }

        public PageStatusHistoryPropertyBuilder authorAccountIds(Set<String> authorAccountIds) {
            this.authorAccountIds = authorAccountIds;
            return this;
        }

        public PageStatusHistoryPropertyBuilder lastChangeTimestamp(long lastChangeTimestamp) {
            this.lastChangeTimestamp = String.valueOf(lastChangeTimestamp);
            return this;
        }

        public PageStatusHistoryPropertyBuilder lastChangeTimestampDate(String lastChangeTimestampDate) {
            this.lastChangeTimestampDate = lastChangeTimestampDate;
            return this;
        }

        public PageStatusHistoryPropertyBuilder changes(List<PageStatusHistoryChange> changes) {
            this.changes = changes;
            return this;
        }

        public PageStatusHistoryProperty build() {
            return new PageStatusHistoryProperty(this);
        }
    }
}

