/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.pagestatus.property.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PageStatusHistoryChange
implements Comparable<PageStatusHistoryChange> {
    @JsonProperty
    private final String authorUserKey;
    @JsonProperty
    private final String authorAccountId;
    @JsonProperty
    private final String statusId;
    @JsonProperty
    private final String setId;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String prevStatusId;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String prevSetId;
    @JsonProperty
    private final String timestamp;
    @JsonProperty
    private final String date;

    @JsonCreator
    private PageStatusHistoryChange() {
        this(PageStatusHistoryChange.builder());
    }

    PageStatusHistoryChange(PageStatusHistoryChangeBuilder builder) {
        this.authorUserKey = builder.authorUserKey;
        this.authorAccountId = builder.authorAccountId;
        this.statusId = builder.statusId;
        this.setId = builder.setId;
        this.prevStatusId = builder.prevStatusId;
        this.prevSetId = builder.prevSetId;
        this.timestamp = builder.timestamp;
        this.date = builder.date;
    }

    @JsonIgnore
    public int getStatusIdAsInt() {
        return Integer.parseInt(this.statusId);
    }

    @JsonIgnore
    public int getSetIdAsInt() {
        return Integer.parseInt(this.setId);
    }

    @JsonIgnore
    public Optional<Integer> getPreviousStatusId() {
        return this.prevStatusId == null ? Optional.empty() : Optional.of(Integer.parseInt(this.prevStatusId));
    }

    @JsonIgnore
    public Optional<Integer> getPreviousSetId() {
        return this.prevSetId == null ? Optional.empty() : Optional.of(Integer.parseInt(this.prevSetId));
    }

    @JsonIgnore
    public long getTimestampAsLong() {
        return Long.parseLong(this.timestamp);
    }

    @JsonIgnore
    public Date getModificationDate() {
        return new Date(this.getTimestampAsLong());
    }

    @Override
    public int compareTo(PageStatusHistoryChange other) {
        return Long.compare(other.getTimestampAsLong(), this.getTimestampAsLong());
    }

    public static PageStatusHistoryChangeBuilder builder() {
        return new PageStatusHistoryChangeBuilder();
    }

    @Generated
    public String getAuthorUserKey() {
        return this.authorUserKey;
    }

    @Generated
    public String getAuthorAccountId() {
        return this.authorAccountId;
    }

    @Generated
    public String getStatusId() {
        return this.statusId;
    }

    @Generated
    public String getSetId() {
        return this.setId;
    }

    @Generated
    public String getPrevStatusId() {
        return this.prevStatusId;
    }

    @Generated
    public String getPrevSetId() {
        return this.prevSetId;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public String toString() {
        return "PageStatusHistoryChange(authorUserKey=" + this.getAuthorUserKey() + ", authorAccountId=" + this.getAuthorAccountId() + ", statusId=" + this.getStatusId() + ", setId=" + this.getSetId() + ", prevStatusId=" + this.getPrevStatusId() + ", prevSetId=" + this.getPrevSetId() + ", timestamp=" + this.getTimestamp() + ", date=" + this.getDate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageStatusHistoryChange)) {
            return false;
        }
        PageStatusHistoryChange other = (PageStatusHistoryChange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authorUserKey = this.getAuthorUserKey();
        String other$authorUserKey = other.getAuthorUserKey();
        if (this$authorUserKey == null ? other$authorUserKey != null : !this$authorUserKey.equals(other$authorUserKey)) {
            return false;
        }
        String this$authorAccountId = this.getAuthorAccountId();
        String other$authorAccountId = other.getAuthorAccountId();
        if (this$authorAccountId == null ? other$authorAccountId != null : !this$authorAccountId.equals(other$authorAccountId)) {
            return false;
        }
        String this$statusId = this.getStatusId();
        String other$statusId = other.getStatusId();
        if (this$statusId == null ? other$statusId != null : !this$statusId.equals(other$statusId)) {
            return false;
        }
        String this$setId = this.getSetId();
        String other$setId = other.getSetId();
        if (this$setId == null ? other$setId != null : !this$setId.equals(other$setId)) {
            return false;
        }
        String this$prevStatusId = this.getPrevStatusId();
        String other$prevStatusId = other.getPrevStatusId();
        if (this$prevStatusId == null ? other$prevStatusId != null : !this$prevStatusId.equals(other$prevStatusId)) {
            return false;
        }
        String this$prevSetId = this.getPrevSetId();
        String other$prevSetId = other.getPrevSetId();
        if (this$prevSetId == null ? other$prevSetId != null : !this$prevSetId.equals(other$prevSetId)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        return !(this$date == null ? other$date != null : !this$date.equals(other$date));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageStatusHistoryChange;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorUserKey = this.getAuthorUserKey();
        result = result * 59 + ($authorUserKey == null ? 43 : $authorUserKey.hashCode());
        String $authorAccountId = this.getAuthorAccountId();
        result = result * 59 + ($authorAccountId == null ? 43 : $authorAccountId.hashCode());
        String $statusId = this.getStatusId();
        result = result * 59 + ($statusId == null ? 43 : $statusId.hashCode());
        String $setId = this.getSetId();
        result = result * 59 + ($setId == null ? 43 : $setId.hashCode());
        String $prevStatusId = this.getPrevStatusId();
        result = result * 59 + ($prevStatusId == null ? 43 : $prevStatusId.hashCode());
        String $prevSetId = this.getPrevSetId();
        result = result * 59 + ($prevSetId == null ? 43 : $prevSetId.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        return result;
    }

    public static class PageStatusHistoryChangeBuilder {
        private String authorUserKey = "";
        private String authorAccountId = "";
        private String statusId = "";
        private String setId = "";
        private String prevStatusId = null;
        private String prevSetId = null;
        private String timestamp;
        private String date = "";

        PageStatusHistoryChangeBuilder() {
        }

        public PageStatusHistoryChangeBuilder authorUserKey(String authorUserKey) {
            this.authorUserKey = authorUserKey;
            return this;
        }

        public PageStatusHistoryChangeBuilder authorAccountId(String authorAccountId) {
            this.authorAccountId = authorAccountId;
            return this;
        }

        public PageStatusHistoryChangeBuilder statusId(int statusId) {
            this.statusId = String.valueOf(statusId);
            return this;
        }

        public PageStatusHistoryChangeBuilder setId(int setId) {
            this.setId = String.valueOf(setId);
            return this;
        }

        public PageStatusHistoryChangeBuilder prevStatusId(Integer prevStatusId) {
            this.prevStatusId = String.valueOf(prevStatusId);
            return this;
        }

        public PageStatusHistoryChangeBuilder prevSetId(Integer prevSetId) {
            this.prevSetId = String.valueOf(prevSetId);
            return this;
        }

        public PageStatusHistoryChangeBuilder timestamp(long timestamp) {
            this.timestamp = String.valueOf(timestamp);
            return this;
        }

        public PageStatusHistoryChangeBuilder date(String date) {
            this.date = date;
            return this;
        }

        public PageStatusHistoryChange build() {
            return new PageStatusHistoryChange(this);
        }
    }
}

