/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.pagestatus.property.impl;

import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentPropertyManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.PageStatusPropertiesManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusHistoryChange;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusHistoryProperty;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusProperty;
import com.stiltsoft.confluence.handy.macros.util.AuthenticatedUserUtil;
import com.stiltsoft.confluence.handy.macros.util.JsonSerializer;
import com.stiltsoft.confluence.handy.macros.util.TimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageStatusPropertiesManager
implements PageStatusPropertiesManager {
    private final ConfluenceContentPropertyManager contentPropertyManager;
    private final JsonSerializer jsonSerializer;
    private final TimeFormatter timeFormatter;
    private final TransactionTemplate transactionTemplate;

    @Override
    public boolean isPageStatusPropertyExists(long contentId) {
        return this.contentPropertyManager.isContentPropertyExists(contentId, "handy-macros_page-status");
    }

    @Override
    public boolean isPageStatusHistoryPropertyExists(long contentId) {
        return this.contentPropertyManager.isContentPropertyExists(contentId, "handy-macros_page-status-history");
    }

    @Override
    public Optional<PageStatusProperty> getPageStatusProperty(long contentId) {
        return this.contentPropertyManager.getContentProperty(contentId, "handy-macros_page-status").map(JsonContentProperty::getValue).map(JsonString::getValue).map(this::deserializePageStatusProperty);
    }

    @Override
    public Optional<PageStatusHistoryProperty> getPageStatusHistoryProperty(long contentId) {
        return this.contentPropertyManager.getContentProperty(contentId, "handy-macros_page-status-history").map(JsonContentProperty::getValue).map(JsonString::getValue).map(this::deserializePageStatusHistoryProperty);
    }

    @Override
    public void createPageStatusProperties(Content content, StatusDto statusDto) {
        Objects.requireNonNull(content);
        Objects.requireNonNull(statusDto);
        String authenticatedUserKey = AuthenticatedUserUtil.getAuthenticatedUserKey().orElse("");
        JsonString pageStatusPropertyValue = this.createPageStatusPropertyValue(statusDto);
        JsonString pageStatusHistoryPropertyValue = this.createPageStatusHistoryPropertyValue(statusDto, authenticatedUserKey);
        this.transactionTemplate.execute(() -> {
            this.contentPropertyManager.createContentProperty(content, "handy-macros_page-status", pageStatusPropertyValue);
            this.contentPropertyManager.createContentProperty(content, "handy-macros_page-status-history", pageStatusHistoryPropertyValue);
            return null;
        });
    }

    @Override
    public void updatePageStatusProperties(Content content, StatusDto statusDto) {
        Objects.requireNonNull(content);
        Objects.requireNonNull(statusDto);
        long contentId = content.getId().asLong();
        String authenticatedUserKey = AuthenticatedUserUtil.getAuthenticatedUserKey().orElse("");
        JsonString pageStatusPropertyValue = this.createPageStatusPropertyValue(statusDto);
        JsonString pageStatusHistoryPropertyValue = this.getPageStatusHistoryProperty(contentId).map(pageStatusHistoryProperty -> this.createUpdatedPageStatusHistoryPropertyValue(statusDto, authenticatedUserKey, (PageStatusHistoryProperty)pageStatusHistoryProperty)).orElseGet(() -> this.createPageStatusHistoryPropertyValue(statusDto, authenticatedUserKey));
        this.transactionTemplate.execute(() -> {
            this.contentPropertyManager.updateContentProperty(content, "handy-macros_page-status", pageStatusPropertyValue);
            this.contentPropertyManager.updateContentProperty(content, "handy-macros_page-status-history", pageStatusHistoryPropertyValue);
            return null;
        });
    }

    @Override
    public void deletePageStatusProperties(long contentId) {
        this.transactionTemplate.execute(() -> {
            this.contentPropertyManager.deleteContentProperty(contentId, "handy-macros_page-status");
            this.contentPropertyManager.deleteContentProperty(contentId, "handy-macros_page-status-history");
            return null;
        });
    }

    private JsonString createPageStatusPropertyValue(StatusDto status) {
        PageStatusProperty newProperty = PageStatusProperty.builder().statusId(status.getId()).statusSetId(status.getStatusSetId()).status(status.getName()).build();
        return new JsonString(this.jsonSerializer.serialize(newProperty));
    }

    private JsonString createPageStatusHistoryPropertyValue(StatusDto statusDto, String userKey) {
        long timestamp = System.currentTimeMillis();
        PageStatusHistoryChange historyChange = this.buildPageStatusHistoryChange(statusDto, userKey, timestamp);
        List<PageStatusHistoryChange> historyChanges = Collections.singletonList(historyChange);
        Set<String> userKeys = Collections.singleton(userKey);
        PageStatusHistoryProperty historyProperty = this.buildPageStatusHistoryProperty(userKey, userKeys, historyChanges, timestamp);
        return new JsonString(this.jsonSerializer.serialize(historyProperty));
    }

    private JsonString createUpdatedPageStatusHistoryPropertyValue(StatusDto status, String newContributorUserKey, PageStatusHistoryProperty previousPageStatusHistoryProperty) {
        long timestamp = System.currentTimeMillis();
        String pageStatusAuthorUserKey = previousPageStatusHistoryProperty.getAuthor();
        Set<String> contributorUserKeys = previousPageStatusHistoryProperty.getAuthorUserKeys();
        List<PageStatusHistoryChange> previousChanges = previousPageStatusHistoryProperty.getChanges();
        List<PageStatusHistoryChange> updatedHistoryChanges = this.getUpdatedPageStatusHistoryChanges(previousChanges, status, newContributorUserKey, timestamp);
        Set<String> updatedUserKeys = DefaultPageStatusPropertiesManager.getUpdatedUserKeys(newContributorUserKey, contributorUserKeys);
        PageStatusHistoryProperty updatedHistoryProperty = this.buildPageStatusHistoryProperty(pageStatusAuthorUserKey, updatedUserKeys, updatedHistoryChanges, timestamp);
        return new JsonString(this.jsonSerializer.serialize(updatedHistoryProperty));
    }

    private List<PageStatusHistoryChange> getUpdatedPageStatusHistoryChanges(List<PageStatusHistoryChange> previousChanges, StatusDto status, String userKey, long timestamp) {
        PageStatusHistoryChange newChange;
        TreeSet<PageStatusHistoryChange> historyChanges = new TreeSet<PageStatusHistoryChange>(previousChanges);
        if (!historyChanges.isEmpty()) {
            PageStatusHistoryChange previousChange = historyChanges.first();
            newChange = this.buildNextPageStatusHistoryChange(status, userKey, timestamp, previousChange);
        } else {
            newChange = this.buildPageStatusHistoryChange(status, userKey, timestamp);
        }
        historyChanges.add(newChange);
        return historyChanges.stream().limit(50L).collect(Collectors.toList());
    }

    private static Set<String> getUpdatedUserKeys(String userKey, Set<String> authors) {
        return Stream.concat(authors.stream(), Stream.of(userKey)).collect(Collectors.toSet());
    }

    private PageStatusHistoryChange buildPageStatusHistoryChange(StatusDto statusDto, String userKey, long timestamp) {
        return PageStatusHistoryChange.builder().authorUserKey(userKey).setId(statusDto.getStatusSetId()).statusId(statusDto.getId()).timestamp(timestamp).date(this.timeFormatter.formatUTC(timestamp)).build();
    }

    private PageStatusHistoryChange buildNextPageStatusHistoryChange(StatusDto status, String userKey, long timestamp, PageStatusHistoryChange previousChange) {
        int prevSetId = previousChange.getSetIdAsInt();
        int prevStatusId = previousChange.getStatusIdAsInt();
        return PageStatusHistoryChange.builder().authorUserKey(userKey).setId(status.getStatusSetId()).statusId(status.getId()).prevSetId(prevSetId).prevStatusId(prevStatusId).timestamp(timestamp).date(this.timeFormatter.formatUTC(timestamp)).build();
    }

    private PageStatusHistoryProperty buildPageStatusHistoryProperty(String author, Set<String> userKeys, List<PageStatusHistoryChange> historyChanges, long timestamp) {
        return PageStatusHistoryProperty.builder().author(author).authorUserKeys(userKeys).changes(historyChanges).lastChangeTimestamp(timestamp).lastChangeTimestampDate(this.timeFormatter.formatUTC(timestamp)).build();
    }

    private PageStatusProperty deserializePageStatusProperty(String pageStatusPropertyValue) {
        return this.jsonSerializer.deserialize(pageStatusPropertyValue, PageStatusProperty.class);
    }

    private PageStatusHistoryProperty deserializePageStatusHistoryProperty(String pageStatusHistoryPropertyValue) {
        return this.jsonSerializer.deserialize(pageStatusHistoryPropertyValue, PageStatusHistoryProperty.class);
    }

    @Generated
    public DefaultPageStatusPropertiesManager(ConfluenceContentPropertyManager contentPropertyManager, JsonSerializer jsonSerializer, TimeFormatter timeFormatter, TransactionTemplate transactionTemplate) {
        this.contentPropertyManager = contentPropertyManager;
        this.jsonSerializer = jsonSerializer;
        this.timeFormatter = timeFormatter;
        this.transactionTemplate = transactionTemplate;
    }
}

