/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.pagestatus.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentPropertyManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.PageStatusService;
import com.stiltsoft.confluence.handy.macros.pagestatus.dto.PageStatusDto;
import com.stiltsoft.confluence.handy.macros.pagestatus.dto.PageStatusEditorDto;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.PageStatusPropertiesManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusProperty;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.util.AuthenticatedUserUtil;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageStatusService
implements PageStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPageStatusService.class);
    private final LicenseManager licenseManager;
    private final HandyPermissionService handyPermissionService;
    private final StatusesService statusesService;
    private final StatusSetService statusSetService;
    private final ConfluenceContentPropertyManager contentPropertyManager;
    private final PageStatusPropertiesManager pageStatusPropertiesManager;

    @Override
    public PageStatusDto getPageStatusOrEmpty(long contentId) {
        boolean isLicensed = this.licenseManager.isActive();
        return this.pageStatusPropertiesManager.getPageStatusProperty(contentId).map(property -> this.getPageStatusFromProperty((PageStatusProperty)property, contentId, isLicensed)).orElse(DefaultPageStatusService.buildEmptyPageStatus(isLicensed));
    }

    @Override
    public PageStatusEditorDto getPageStatusForEditorOrEmpty(long contentId, String spaceKey) {
        Objects.requireNonNull(spaceKey, "spaceKey must not be null");
        boolean canEdit = this.handyPermissionService.hasCurrentUserContentEditPermission(contentId);
        boolean isLicensed = this.licenseManager.isActive();
        return this.pageStatusPropertiesManager.getPageStatusProperty(contentId).map(property -> this.getPageStatusForEditorFromProperty((PageStatusProperty)property, contentId, canEdit, isLicensed)).orElseGet(() -> this.getPageStatusForEditorFromFirstAvailable(contentId, spaceKey, canEdit, isLicensed).orElse(DefaultPageStatusService.buildEmptyPageStatusForEditor(canEdit, isLicensed)));
    }

    @Override
    public void addPageStatusForContent(Content content, int statusId, int statusSetId) {
        Objects.requireNonNull(content, "content must not be null");
        long contentId = content.getId().asLong();
        if (this.pageStatusPropertiesManager.isPageStatusPropertyExists(contentId)) {
            log.warn("Page Status content property already exists, contentId={}, statusId={}, statusSetId={}", new Object[]{contentId, statusId, statusSetId});
            throw new ConflictException("Page Status property already exists");
        }
        if (this.pageStatusPropertiesManager.isPageStatusHistoryPropertyExists(contentId)) {
            log.warn("Deleting the Page Status History content property to create a new one, contentId={}.", (Object)contentId);
            this.contentPropertyManager.deleteContentProperty(contentId, "handy-macros_page-status-history");
        }
        StatusDto statusToAdd = this.getValidStatusDtoToSave(contentId, statusId, statusSetId);
        this.pageStatusPropertiesManager.createPageStatusProperties(content, statusToAdd);
    }

    @Override
    public void updatePageStatusForContent(Content content, int statusId, int statusSetId) {
        Objects.requireNonNull(content, "content must not be null");
        long contentId = content.getId().asLong();
        Optional<PageStatusProperty> propertyOptional = this.pageStatusPropertiesManager.getPageStatusProperty(contentId);
        if (!propertyOptional.isPresent()) {
            log.warn("There is no Page Status content property for contentId={}.", (Object)contentId);
            throw new NotFoundException("Page Status property not found");
        }
        PageStatusProperty property = propertyOptional.get();
        if (property.getStatusIdAsInt() == statusId && property.getSetIdAsInt() == statusSetId) {
            log.warn("Page Status content property has not changed, contentId={}.", (Object)contentId);
        } else {
            StatusDto statusToUpdate = this.getValidStatusDtoToSave(contentId, statusId, statusSetId);
            this.pageStatusPropertiesManager.updatePageStatusProperties(content, statusToUpdate);
        }
    }

    @Override
    public void deletePageStatusForContent(long contentId) {
        this.pageStatusPropertiesManager.deletePageStatusProperties(contentId);
    }

    private StatusDto getValidStatusDtoToSave(long contentId, int statusId, int statusSetId) {
        Optional<StatusDto> statusFromCacheOrDB = this.statusesService.getStatusFromCacheOrDB(statusId);
        Optional<StatusSetDto> statusSetOptional = this.statusesService.getStatusSetFromCacheOrDB(statusSetId);
        if (!statusFromCacheOrDB.isPresent()) {
            log.warn("Cannot get a status, contentId={}, statusId={}", (Object)contentId, (Object)statusId);
            throw new NotFoundException("Handy Status not found");
        }
        if (!statusSetOptional.isPresent()) {
            log.warn("Cannot get a status set, contentId={}, statusSetId={}.", (Object)contentId, (Object)statusSetId);
            throw new NotFoundException("Handy Status Set not found");
        }
        StatusDto validStatusDto = statusFromCacheOrDB.get();
        if (validStatusDto.getStatusSetId() != statusSetId) {
            log.warn("Status details are not correct, contentId={}, statusSetId={}.", (Object)contentId, (Object)statusSetId);
            throw new BadRequestException("Status details are not correct");
        }
        return validStatusDto;
    }

    private PageStatusDto getPageStatusFromProperty(PageStatusProperty property, long contentId, boolean isLicensed) {
        int statusId = property.getStatusIdAsInt();
        Optional<StatusDto> statusFromCacheOrDB = this.statusesService.getStatusFromCacheOrDB(statusId);
        if (!statusFromCacheOrDB.isPresent()) {
            log.warn("Cannot get a status for the page status, contentId={}, statusId={}", (Object)contentId, (Object)statusId);
        }
        return statusFromCacheOrDB.map(status -> this.getPageStatusDtoFromStatus((StatusDto)status, isLicensed)).orElse(DefaultPageStatusService.buildUnknownPageStatus(isLicensed));
    }

    private PageStatusDto getPageStatusDtoFromStatus(StatusDto status, boolean isLicensed) {
        Optional<StatusSetDto> statusSetFromCacheOrDB = this.statusesService.getStatusSetFromCacheOrDB(status.getStatusSetId());
        Integer statusWidth = statusSetFromCacheOrDB.map(StatusSetDto::getWidth).orElse(null);
        return PageStatusDto.builder().status(status).width(statusWidth).licensed(isLicensed).build();
    }

    private PageStatusEditorDto getPageStatusForEditorFromProperty(PageStatusProperty property, long contentId, boolean canEdit, boolean isLicensed) {
        int statusId = property.getStatusIdAsInt();
        int statusSetId = property.getSetIdAsInt();
        return this.getPageStatusEditorDto(contentId, true, statusId, statusSetId, canEdit, isLicensed);
    }

    private Optional<PageStatusEditorDto> getPageStatusForEditorFromFirstAvailable(long contentId, String spaceKey, boolean canEdit, boolean isLicensed) {
        String userKey = AuthenticatedUserUtil.getAuthenticatedUserKey().orElse(null);
        return this.statusSetService.getFirstAvailableStatus(spaceKey, userKey).map(status -> {
            int statusId = status.getId();
            int statusSetId = status.getStatusSetId();
            return this.getPageStatusEditorDto(contentId, false, statusId, statusSetId, canEdit, isLicensed);
        });
    }

    private PageStatusEditorDto getPageStatusEditorDto(long contentId, boolean isContentPropertyStatus, int statusId, int statusSetId, boolean canEdit, boolean isLicensed) {
        Optional<StatusDto> statusFromCacheOrDB = this.statusesService.getStatusFromCacheOrDB(statusId);
        Optional<StatusSetDto> statusSetFromCacheOrDB = this.statusesService.getStatusSetFromCacheOrDB(statusSetId);
        if (!statusFromCacheOrDB.isPresent()) {
            log.warn("Cannot get a status for the page status editor, contentId={}, statusId={}", (Object)contentId, (Object)statusId);
        }
        if (!statusSetFromCacheOrDB.isPresent()) {
            log.warn("Cannot get a status set for the page status editor, contentId={}, statusSetId={}.", (Object)contentId, (Object)statusSetId);
        }
        StatusSetDto statusSetDtoWithFormattedName = statusSetFromCacheOrDB.map(this::createStatusSetDtoWithFormattedName).orElse(null);
        return PageStatusEditorDto.builder().status(statusFromCacheOrDB.orElse(StatusDto.UNKNOWN_STATUS)).statusSet(statusSetDtoWithFormattedName).isContentPropertyStatus(isContentPropertyStatus).canUserEditContent(canEdit).licensed(isLicensed).build();
    }

    private StatusSetDto createStatusSetDtoWithFormattedName(StatusSetDto statusSetDto) {
        String statusSetName = DefaultPageStatusService.getFormattedStatusSetName(statusSetDto);
        return new StatusSetDto(statusSetDto.getId(), statusSetName, statusSetDto.getOwner(), statusSetDto.getParentId(), statusSetDto.getViewType(), statusSetDto.getWidth());
    }

    private static String getFormattedStatusSetName(StatusSetDto statusSetDto) {
        ConfluenceUser user = AuthenticatedUserUtil.getAuthenticatedUser().orElse(null);
        Object prefix = "";
        if (statusSetDto.getOwner().startsWith("user:")) {
            prefix = user == null ? "" : user.getFullName() + ": ";
        } else if (statusSetDto.getOwner().startsWith("space:")) {
            prefix = statusSetDto.getOwner().replace("space:", "") + ": ";
        }
        return (String)prefix + statusSetDto.getName();
    }

    private static PageStatusDto buildEmptyPageStatus(boolean isLicensed) {
        return PageStatusDto.builder().licensed(isLicensed).build();
    }

    private static PageStatusDto buildUnknownPageStatus(boolean isLicensed) {
        return PageStatusDto.builder().status(StatusDto.UNKNOWN_STATUS).licensed(isLicensed).build();
    }

    private static PageStatusEditorDto buildEmptyPageStatusForEditor(boolean canEdit, boolean isLicensed) {
        return PageStatusEditorDto.builder().canUserEditContent(canEdit).licensed(isLicensed).build();
    }

    @Generated
    public DefaultPageStatusService(LicenseManager licenseManager, HandyPermissionService handyPermissionService, StatusesService statusesService, StatusSetService statusSetService, ConfluenceContentPropertyManager contentPropertyManager, PageStatusPropertiesManager pageStatusPropertiesManager) {
        this.licenseManager = licenseManager;
        this.handyPermissionService = handyPermissionService;
        this.statusesService = statusesService;
        this.statusSetService = statusSetService;
        this.contentPropertyManager = contentPropertyManager;
        this.pageStatusPropertiesManager = pageStatusPropertiesManager;
    }
}

