/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.pagestatus.impl;

import com.atlassian.confluence.core.DateFormatter;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.manager.HandyDateFormatter;
import com.stiltsoft.confluence.handy.macros.pagestatus.PageStatusHistoryService;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.PageStatusPropertiesManager;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusHistoryChange;
import com.stiltsoft.confluence.handy.macros.pagestatus.property.model.PageStatusHistoryProperty;
import com.stiltsoft.confluence.handy.macros.rest.entity.UserRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.pagestatus.entity.history.PageStatusHistoryRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.view.ViewRestEntityUtil;
import com.stiltsoft.confluence.handy.macros.user.UserResourceService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageStatusHistoryService
implements PageStatusHistoryService {
    private final PageStatusPropertiesManager propertiesManager;
    private final StatusManager statusManager;
    private final StatusSetManager statusSetManager;
    private final UserResourceService userResourceService;
    private final HandyDateFormatter handyDateFormatter;

    @Override
    public List<PageStatusHistoryRestEntity> getPageStatusHistoryRestEntities(long contentId) {
        Optional<PageStatusHistoryProperty> pageStatusHistoryProperty = this.propertiesManager.getPageStatusHistoryProperty(contentId);
        if (!pageStatusHistoryProperty.isPresent()) {
            return Collections.emptyList();
        }
        PageStatusHistoryProperty historyProperty = pageStatusHistoryProperty.get();
        DateFormatter dateFormatter = this.handyDateFormatter.getDateFormatter();
        HashMap statusById = new HashMap();
        HashMap statusSetById = new HashMap();
        return historyProperty.getChanges().stream().map(historyChange -> this.getPageStatusHistoryRestEntity((PageStatusHistoryChange)historyChange, statusById, statusSetById, dateFormatter)).collect(Collectors.toList());
    }

    private PageStatusHistoryRestEntity getPageStatusHistoryRestEntity(PageStatusHistoryChange historyChange, Map<Integer, StatusDto> statusById, Map<Integer, StatusSetDto> statusSetById, DateFormatter dateFormatter) {
        StatusDto newStatus = this.getStatusFromMapOrDB(historyChange.getStatusIdAsInt(), statusById);
        Optional<StatusDto> oldStatus = historyChange.getPreviousStatusId().map(statusId -> this.getStatusFromMapOrDB((int)statusId, statusById));
        Integer newStatusWidth = this.getStatusWidth(newStatus, statusSetById);
        Integer oldStatusWidth = oldStatus.map(status -> this.getStatusWidth((StatusDto)status, statusSetById)).orElse(null);
        StatusRestEntity newStatusRestEntity = ViewRestEntityUtil.toStatusRestEntity(newStatus);
        StatusRestEntity oldStatusRestEntity = oldStatus.map(ViewRestEntityUtil::toStatusRestEntity).orElse(null);
        UserRestEntity userRestEntity = this.userResourceService.getUserRestEntity(historyChange.getAuthorUserKey());
        String modificationDateFormatted = dateFormatter.formatDateTime(historyChange.getModificationDate());
        return PageStatusHistoryRestEntity.builder().newStatus(newStatusRestEntity).newStatusWidth(newStatusWidth).oldStatus(oldStatusRestEntity).oldStatusWidth(oldStatusWidth).user(userRestEntity).date(modificationDateFormatted).build();
    }

    private Integer getStatusWidth(StatusDto status, Map<Integer, StatusSetDto> statusSetById) {
        int statusSetId = status.getStatusSetId();
        if (statusSetId <= 0) {
            return null;
        }
        return Optional.ofNullable(this.getStatusSetFromMapOrDB(statusSetId, statusSetById)).map(StatusSetDto::getWidth).orElse(null);
    }

    private StatusDto getStatusFromMapOrDB(int statusId, Map<Integer, StatusDto> statusById) {
        return statusById.computeIfAbsent(statusId, id -> this.statusManager.getStatus((int)id).orElse(StatusDto.UNKNOWN_STATUS));
    }

    private StatusSetDto getStatusSetFromMapOrDB(int statusSetId, Map<Integer, StatusSetDto> statusSetById) {
        return statusSetById.computeIfAbsent(statusSetId, id -> this.statusSetManager.getStatusSetById((int)id).orElse(null));
    }

    @Generated
    public DefaultPageStatusHistoryService(PageStatusPropertiesManager propertiesManager, StatusManager statusManager, StatusSetManager statusSetManager, UserResourceService userResourceService, HandyDateFormatter handyDateFormatter) {
        this.propertiesManager = propertiesManager;
        this.statusManager = statusManager;
        this.statusSetManager = statusSetManager;
        this.userResourceService = userResourceService;
        this.handyDateFormatter = handyDateFormatter;
    }
}

