/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.migration.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroIdMapEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusSetEntity;
import com.stiltsoft.confluence.handy.macros.migration.ao.CloudMigrationDAO;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationMacro;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationMacroMap;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationStatus;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationStatusSetWithUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultCloudMigrationDAO
implements CloudMigrationDAO {
    private final ActiveObjects ao;

    public DefaultCloudMigrationDAO(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Collection<MigrationMacroMap> getMigrationMacroMaps(int offset, int limit) {
        ArrayList<MigrationMacroMap> migrationMacroMaps = new ArrayList<MigrationMacroMap>(limit);
        Query query = Query.select((String)"ID, CURRENT_ID, OLD_ID, PAGE_ID").where("PAGE_ID IS NOT NULL", new Object[0]).offset(offset).limit(limit).order("ID DESC");
        this.ao.stream(StatusMacroIdMapEntity.class, query, statusMacroIdMapEntity -> {
            long pageId = statusMacroIdMapEntity.getConfluencePageId();
            int currentMacroId = statusMacroIdMapEntity.getCurrentId();
            int oldMacroId = statusMacroIdMapEntity.getOldId();
            migrationMacroMaps.add(new MigrationMacroMap(currentMacroId, oldMacroId, pageId));
        });
        return migrationMacroMaps;
    }

    @Override
    public Collection<MigrationStatusSetWithUser> getMigrationStatusSets(int offset, int limit) {
        ArrayList statusSets = new ArrayList(limit);
        Query query = Query.select((String)"ID, NAME, OWNER").offset(offset).limit(limit).order("ID DESC");
        this.ao.stream(StatusSetEntity.class, query, statusSets::add);
        return statusSets.stream().map(this::toMigrationStatusSet).collect(Collectors.toList());
    }

    @Override
    public Collection<MigrationStatus> getMigrationStatuses(int offset, int limit) {
        Query query = Query.select().offset(offset).limit(limit).order("ID DESC");
        return Stream.of((StatusEntity[])this.ao.find(StatusEntity.class, query)).map(this::toMigrationStatus).collect(Collectors.toList());
    }

    @Override
    public Collection<MigrationMacro> getMigrationMacros(int offset, int limit) {
        ArrayList statusMacroEntities = new ArrayList(limit);
        Query query = Query.select((String)"ID, PAGE_ID, CATEGORY, STATUS, LABELLED, PREFIX").where("PAGE_ID IS NOT NULL AND STATUS IS NOT NULL", new Object[0]).offset(offset).limit(limit).order("ID DESC");
        this.ao.stream(StatusMacroEntity.class, query, statusMacroEntities::add);
        return statusMacroEntities.stream().map(this::toMigrationMacro).collect(Collectors.toList());
    }

    @Override
    public int countMigrationMacros() {
        Query query = Query.select((String)"ID").where("PAGE_ID IS NOT NULL AND STATUS IS NOT NULL", new Object[0]);
        return this.ao.count(StatusMacroEntity.class, query);
    }

    @Override
    public int countMigrationMacrosMaps() {
        Query query = Query.select((String)"ID").where("PAGE_ID IS NOT NULL", new Object[0]);
        return this.ao.count(StatusMacroIdMapEntity.class, query);
    }

    @Override
    public int countMigrationStatuses() {
        return this.ao.count(StatusEntity.class, Query.select((String)"ID"));
    }

    @Override
    public int countMigrationStatusSets() {
        return this.ao.count(StatusSetEntity.class, Query.select((String)"ID"));
    }

    private MigrationStatusSetWithUser toMigrationStatusSet(StatusSetEntity statusSetEntity) {
        String setName;
        String owner = statusSetEntity.getOwner();
        String string = setName = Objects.isNull(statusSetEntity.getName()) ? "" : statusSetEntity.getName();
        if (owner.startsWith("user:")) {
            String userKey = owner.replace("user:", "");
            return new MigrationStatusSetWithUser(statusSetEntity.getID(), setName, userKey);
        }
        if (owner.startsWith("space:")) {
            setName = this.getMigrationSpaceSetName(setName, owner);
        }
        return new MigrationStatusSetWithUser(statusSetEntity.getID(), setName);
    }

    private MigrationStatus toMigrationStatus(StatusEntity statusEntity) {
        return new MigrationStatus(statusEntity.getID(), statusEntity.getStatusSet().getID(), statusEntity.getName(), statusEntity.getTextColor(), statusEntity.getBackgroundColor(), Optional.ofNullable(statusEntity.getPriority()).orElse(0));
    }

    private MigrationMacro toMigrationMacro(StatusMacroEntity statusMacroEntity) {
        return new MigrationMacro(statusMacroEntity.getID(), statusMacroEntity.getStatusSetId(), statusMacroEntity.getStatusId(), statusMacroEntity.getConfluencePageId(), Optional.ofNullable(statusMacroEntity.getLabelled()).orElse(false), statusMacroEntity.getLabelPrefix());
    }

    private String getMigrationSpaceSetName(String setName, String owner) {
        String spaceKey = owner.replace("space:", "");
        return String.format("%s space(%s)", setName, spaceKey);
    }
}

