/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.migration;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stiltsoft.confluence.handy.macros.migration.BackOffStrategyService;
import com.stiltsoft.confluence.handy.macros.migration.CloudMigrationFailedException;
import com.stiltsoft.confluence.handy.macros.migration.ao.CloudMigrationDAO;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationDataChunk;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationDataStatistics;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationMacro;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationMacroMap;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationStatusSet;
import com.stiltsoft.confluence.handy.macros.migration.dto.MigrationStatusSetWithUser;
import com.stiltsoft.confluence.handy.macros.util.CollectionUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandyMacrosCloudMigrationListener
implements DiscoverableListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandyMacrosCloudMigrationListener.class);
    private static final int CHUNK_SIZE = 500;
    private final TransactionTemplate transactionTemplate;
    private final CloudMigrationDAO cloudMigrationDAO;
    private final ObjectMapper objectMapper;
    private final UserAccessor userAccessor;

    public HandyMacrosCloudMigrationListener(TransactionTemplate transactionTemplate, CloudMigrationDAO cloudMigrationDAO, UserAccessor userAccessor) {
        this.transactionTemplate = transactionTemplate;
        this.cloudMigrationDAO = cloudMigrationDAO;
        this.userAccessor = userAccessor;
        this.objectMapper = new ObjectMapper();
    }

    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        log.warn("The Handy Macros migration has started. (transferID = {})", (Object)transferId);
        try {
            log.warn("getAndSendMigrationDataStatistics");
            this.getAndSendMigrationDataStatistics(transferId, gateway);
            log.warn("getAndSendStatusSets");
            int sentChunks = this.getAndSendStatusSets(transferId, gateway);
            log.warn("getAndSendStatuses");
            sentChunks += this.getAndSendStatuses(transferId, gateway);
            log.warn("getAndSendMacroMaps");
            sentChunks += this.getAndSendMacroMaps(transferId, gateway);
            log.warn("getAndSendMacros");
            log.warn("sendChunkStatistics");
            this.sendChunkStatistics(transferId, gateway, sentChunks += this.getAndSendMacros(transferId, gateway));
            log.warn("The Handy Macros migration has finished successfully. (transferID = {})", (Object)transferId);
        }
        catch (Throwable throwable) {
            log.error("The Handy Macros migration has failed. (transferID = {})", (Object)transferId, (Object)throwable);
        }
    }

    public String getCloudAppKey() {
        return "com.stiltsoft.confluence.handy.macros";
    }

    public String getServerAppKey() {
        return "com.stiltsoft.confluence.handy.macros";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_UGC, AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_UGC, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    private void getAndSendMigrationDataStatistics(String transferId, AppCloudMigrationGateway gateway) {
        String label = "data_statistics";
        int macroMaps = (Integer)this.transactionTemplate.execute(this.cloudMigrationDAO::countMigrationMacrosMaps);
        int statusSets = (Integer)this.transactionTemplate.execute(this.cloudMigrationDAO::countMigrationStatusSets);
        int statuses = (Integer)this.transactionTemplate.execute(this.cloudMigrationDAO::countMigrationStatuses);
        int macros = (Integer)this.transactionTemplate.execute(this.cloudMigrationDAO::countMigrationMacros);
        MigrationDataStatistics statistics = new MigrationDataStatistics(macroMaps, statusSets, statuses, macros, 500);
        try {
            this.createAppDataChunk(transferId, gateway, label, statistics);
        }
        catch (IOException e) {
            log.error("Couldn't send migration data statistics.");
        }
    }

    private int getAndSendStatuses(String transferId, AppCloudMigrationGateway gateway) {
        return this.getAndSendData(transferId, "statuses_%d-%d", gateway, offset -> {
            try {
                Collection migrationStatuses = (Collection)this.transactionTemplate.execute(() -> this.cloudMigrationDAO.getMigrationStatuses((int)offset, 500));
                return new MigrationDataChunk(migrationStatuses.size(), migrationStatuses);
            }
            catch (Throwable throwable) {
                log.error("Could not get and send data ", throwable);
                throw new CloudMigrationFailedException("Something went wrong", throwable);
            }
        });
    }

    private int getAndSendStatusSets(String transferId, AppCloudMigrationGateway gateway) {
        return this.getAndSendData(transferId, "status-sets_%d-%d", gateway, offset -> {
            try {
                Collection migrationStatusSetWithUsers = (Collection)this.transactionTemplate.execute(() -> this.cloudMigrationDAO.getMigrationStatusSets((int)offset, 500));
                log.warn("MigrationStatusSetWithUser = {}", (Object)migrationStatusSetWithUsers.toString());
                Collection<MigrationStatusSet> preparedMigrationStatusSets = this.getPreparedMigrationStatusSets(transferId, gateway, migrationStatusSetWithUsers);
                log.warn("MigrationStatusSet = {}, size = {}, offset = {}.", new Object[]{preparedMigrationStatusSets.toString(), migrationStatusSetWithUsers.size(), offset});
                return new MigrationDataChunk(migrationStatusSetWithUsers.size(), preparedMigrationStatusSets);
            }
            catch (Throwable throwable) {
                log.error("Could not get and send data ", throwable);
                throw new CloudMigrationFailedException("Something went wrong", throwable);
            }
        });
    }

    private int getAndSendMacroMaps(String transferId, AppCloudMigrationGateway gateway) {
        return this.getAndSendData(transferId, "macro-maps_%d-%d", gateway, offset -> {
            try {
                Collection migrationMacroMaps = (Collection)this.transactionTemplate.execute(() -> this.cloudMigrationDAO.getMigrationMacroMaps((int)offset, 500));
                log.warn("BEFORE - MigrationMacroMap = {}", (Object)migrationMacroMaps.toString());
                Collection<MigrationMacroMap> preparedMigrationMacroMaps = this.getPreparedMigrationMacroMaps(transferId, gateway, migrationMacroMaps);
                log.warn("AFTER - MigrationMacroMap = {}, size = {}, offset = {}", new Object[]{preparedMigrationMacroMaps.toString(), migrationMacroMaps.size(), offset});
                return new MigrationDataChunk(migrationMacroMaps.size(), preparedMigrationMacroMaps);
            }
            catch (Throwable throwable) {
                log.error("Could not get and send data ", throwable);
                throw new CloudMigrationFailedException("Something went wrong", throwable);
            }
        });
    }

    private int getAndSendMacros(String transferId, AppCloudMigrationGateway gateway) {
        return this.getAndSendData(transferId, "macros_%d-%d", gateway, offset -> {
            try {
                Collection migrationMacros = (Collection)this.transactionTemplate.execute(() -> this.cloudMigrationDAO.getMigrationMacros((int)offset, 500));
                log.warn("BEFORE - MigrationMacro = {}", (Object)migrationMacros.toString());
                Collection<MigrationMacro> preparedMigrationMacros = this.getPreparedMigrationMacros(transferId, gateway, migrationMacros);
                log.warn("AFTER - MigrationMacro = {}, size = {}, offset = {}", new Object[]{preparedMigrationMacros.toString(), preparedMigrationMacros.size(), offset});
                return new MigrationDataChunk(migrationMacros.size(), preparedMigrationMacros);
            }
            catch (Throwable throwable) {
                log.error("Could not get and send data ", throwable);
                throw new CloudMigrationFailedException("Something went wrong", throwable);
            }
        });
    }

    private Collection<MigrationMacroMap> getPreparedMigrationMacroMaps(String transferId, AppCloudMigrationGateway gateway, Collection<MigrationMacroMap> migrationMacroMaps) {
        Collection serverConfluencePageId = migrationMacroMaps.stream().map(MigrationMacroMap::getConfluencePageId).collect(Collectors.toSet());
        log.warn("ServerConfluencePageIds = {}", (Object)serverConfluencePageId);
        Map<String, String> cloudPageIdByServerPageId = this.getMappingByIdWithBackoff(gateway, transferId, "confluence:page", this.getUniqStringPageIds(serverConfluencePageId));
        log.warn("cloudPageIdByServerPageId = {}", cloudPageIdByServerPageId);
        return migrationMacroMaps.stream().map(migrationMacroMap -> {
            String rawServerConfluencePageId = Long.toString(migrationMacroMap.getConfluencePageId());
            String rawCloudConfluencePageId = (String)cloudPageIdByServerPageId.get(rawServerConfluencePageId);
            if (rawCloudConfluencePageId == null) {
                migrationMacroMap.setConfluencePageId(-1L);
                return migrationMacroMap;
            }
            long cloudConfluencePageId = Long.parseLong(rawCloudConfluencePageId);
            migrationMacroMap.setConfluencePageId(cloudConfluencePageId);
            return migrationMacroMap;
        }).collect(Collectors.toList());
    }

    private Collection<MigrationStatusSet> getPreparedMigrationStatusSets(String transferId, AppCloudMigrationGateway gateway, Collection<MigrationStatusSetWithUser> migrationStatusSetWithUsers) {
        String queryPrefix = "confluence.userkey/";
        Set<String> userKeys = migrationStatusSetWithUsers.stream().map(MigrationStatusSetWithUser::getOwnerUserKey).filter(Optional::isPresent).map(Optional::get).map(userKey -> queryPrefix + userKey).collect(Collectors.toSet());
        log.warn("userKeys = {}", userKeys);
        Map<String, String> userAccountIdByPrefixAndUserKey = this.getMappingByIdWithBackoff(gateway, transferId, "identity:user", userKeys);
        log.warn("userAccountIdByPrefixAndUserKey = {}", (Object)this.mapToString(userAccountIdByPrefixAndUserKey));
        return migrationStatusSetWithUsers.stream().peek(migrationStatusSetWithUser -> migrationStatusSetWithUser.getOwnerUserKey().ifPresent(userKey -> {
            String selectorUserKey = queryPrefix + userKey;
            String userAccountId = this.getUserAccountId(transferId, gateway, userAccountIdByPrefixAndUserKey, selectorUserKey);
            migrationStatusSetWithUser.setName(String.format("%s personal (%s)", migrationStatusSetWithUser.getName(), userAccountId));
        })).map(set -> new MigrationStatusSet(set.getId(), set.getName())).collect(Collectors.toList());
    }

    private Collection<MigrationMacro> getPreparedMigrationMacros(String transferId, AppCloudMigrationGateway gateway, Collection<MigrationMacro> migrationMacros) {
        Collection serverConfluencePageId = migrationMacros.stream().map(MigrationMacro::getPageId).collect(Collectors.toSet());
        log.warn("ServerConfluencePageIds = {}", (Object)serverConfluencePageId);
        Map<String, String> cloudPageIdByServerPageId = this.getMappingByIdWithBackoff(gateway, transferId, "confluence:page", this.getUniqStringPageIds(serverConfluencePageId));
        log.warn("cloudPageIdByServerPageId = {}", cloudPageIdByServerPageId);
        return migrationMacros.stream().map(migrationMacro -> {
            String rawServerConfluencePageId = Long.toString(migrationMacro.getPageId());
            String rawCloudConfluencePageId = (String)cloudPageIdByServerPageId.get(rawServerConfluencePageId);
            if (rawCloudConfluencePageId == null) {
                migrationMacro.setPageId(-1L);
                return migrationMacro;
            }
            long cloudConfluencePageId = Long.parseLong(rawCloudConfluencePageId);
            migrationMacro.setPageId(cloudConfluencePageId);
            return migrationMacro;
        }).collect(Collectors.toList());
    }

    private void sendChunkStatistics(String transferId, AppCloudMigrationGateway gateway, int countChunks) {
        String label = String.format("chunks_%d", countChunks);
        try {
            OutputStream appDataStream = gateway.createAppData(transferId, label);
            appDataStream.write(0);
            appDataStream.close();
        }
        catch (IOException e) {
            log.error("Cannot send a chunk statistic.");
        }
    }

    private int getAndSendData(String transferId, String labelPattern, AppCloudMigrationGateway gateway, Function<Integer, MigrationDataChunk> dataProvider) {
        int offset = 0;
        int sentChunks = 0;
        boolean allChunksSent = false;
        while (!allChunksSent) {
            MigrationDataChunk dataChunk = dataProvider.apply(offset);
            int chunkSize = dataChunk.getSize();
            String chunkLabel = String.format(labelPattern, offset, offset + chunkSize);
            log.warn("Chunk = {}", (Object)chunkLabel);
            try {
                this.createAppDataChunk(transferId, gateway, chunkLabel, dataChunk.getData());
                offset += chunkSize;
                ++sentChunks;
            }
            catch (IOException e) {
                log.error("Couldn't send chunk {}", (Object)chunkLabel);
            }
            if (chunkSize == 500) continue;
            allChunksSent = true;
        }
        return sentChunks;
    }

    private void createAppDataChunk(String transferId, AppCloudMigrationGateway gateway, String chunkLabel, Object data) throws IOException {
        BackOffStrategyService backoff = new BackOffStrategyService();
        while (backoff.shouldRetry()) {
            try {
                OutputStream appDataStream = gateway.createAppData(transferId, chunkLabel);
                appDataStream.write(this.objectMapper.writeValueAsBytes(data));
                appDataStream.close();
                backoff.doNotRetry();
                log.warn("Data sent. Chunk = {}", (Object)chunkLabel);
                break;
            }
            catch (Throwable throwable) {
                log.error("Couldn't send app's data.", throwable);
                backoff.errorOccurred();
            }
        }
    }

    private String getUserAccountId(String transferId, AppCloudMigrationGateway gateway, Map<String, String> userAccountIdByPrefixAndUserKey, String selectorUserKey) {
        return userAccountIdByPrefixAndUserKey.computeIfAbsent(selectorUserKey, key -> Optional.ofNullable(this.userAccessor.getUserByKey(new UserKey(key))).map(user -> {
            log.error("HANDY MACROS - MIGRATION. Could not get user account id BY USERKEY for user key={}, full name={}, email={}, transferId={}.", new Object[]{user.getKey().getStringValue(), user.getFullName(), user.getEmail(), transferId});
            String selectorEmail = "email/" + user.getEmail();
            Map<String, String> accountIdByEmail = this.getMappingByIdWithBackoff(gateway, transferId, "identity:user", Collections.singleton(selectorEmail));
            String emailAccountId = accountIdByEmail.get(selectorEmail);
            if (emailAccountId == null) {
                log.error("HANDY MACROS - MIGRATION. Could not get user account id BY EMAIL for user key={}, full name={}, email={}, transferId={}.", new Object[]{user.getKey().getStringValue(), user.getFullName(), user.getEmail(), transferId});
                return "unknown accountID";
            }
            return emailAccountId;
        }).orElseGet(() -> {
            log.error("HANDY MACROS - MIGRATION. Could not get CONFLUENCE user BY USERKEY key={}, selectorUserKey={}, transferId={}.", new Object[]{key, selectorUserKey, transferId});
            return "unknown accountID";
        }));
    }

    private Map<String, String> getMappingByIdWithBackoff(AppCloudMigrationGateway gateway, String transferId, String namespace, Set<String> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        BackOffStrategyService backoff = new BackOffStrategyService();
        while (backoff.shouldRetry()) {
            try {
                return this.getBatchedMappingById(gateway, transferId, namespace, ids);
            }
            catch (Throwable throwable) {
                log.error("Couldn't get mappings (transferId={}, namespace={}).", new Object[]{transferId, namespace, throwable});
                backoff.errorOccurred();
            }
        }
        throw new CloudMigrationFailedException(String.format("Couldn't get mappings (transferId=%s, namespace=%s).", transferId, namespace));
    }

    private Map<String, String> getBatchedMappingById(AppCloudMigrationGateway gateway, String transferId, String namespace, Set<String> ids) {
        List<Collection<String>> batches = CollectionUtil.splitCollection(ids, 100);
        HashMap<String, String> mappingsById = new HashMap<String, String>(ids.size() * 2);
        for (Collection<String> batch : batches) {
            mappingsById.putAll(gateway.getMappingById(transferId, namespace, new HashSet<String>(batch)));
        }
        return mappingsById;
    }

    private Set<String> getUniqStringPageIds(Collection<Long> confluencePageIds) {
        return confluencePageIds.stream().map(Object::toString).collect(Collectors.toSet());
    }

    private String mapToString(Map<String, String> map) {
        return map.keySet().stream().map(key -> key + "=" + (String)map.get(key)).collect(Collectors.joining(", ", "{", "}"));
    }
}

