/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.migration;

import java.util.Random;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackOffStrategyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackOffStrategyService.class);
    public static int defaultRetries = 3;
    public static long defaultWaitTimeInMills = 60000L;
    private int numberOfTriesLeft;
    private long timeToWait;
    private final Random random = new Random();

    public BackOffStrategyService() {
        this(defaultRetries, defaultWaitTimeInMills);
    }

    public BackOffStrategyService(int numberOfRetries, long defaultTimeToWait) {
        this.numberOfTriesLeft = numberOfRetries;
        this.timeToWait = defaultTimeToWait;
    }

    public boolean shouldRetry() {
        return this.numberOfTriesLeft > 0;
    }

    public void errorOccurred() {
        --this.numberOfTriesLeft;
        if (!this.shouldRetry()) {
            log.warn("RETRY FAILED");
        }
        this.waitUntilNextTry();
        this.timeToWait += (long)this.random.nextInt(1000);
    }

    private void waitUntilNextTry() {
        try {
            Thread.sleep(this.timeToWait);
        }
        catch (InterruptedException e) {
            log.error("Cannot perform thread.sleep({}).", (Object)this.timeToWait, (Object)e);
        }
    }

    public void doNotRetry() {
        this.numberOfTriesLeft = 0;
    }
}

