/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.manager.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentPropertyManager;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultConfluenceContentPropertyManager
implements ConfluenceContentPropertyManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConfluenceContentPropertyManager.class);
    private static final Expansion[] DEFAULT_EXPANSIONS = new Expansion[]{new Expansion("content"), new Expansion("version")};
    private final ContentPropertyService contentPropertyService;

    @Override
    public Optional<JsonContentProperty> getContentProperty(long contentId, String propertyKey) {
        Objects.requireNonNull(propertyKey);
        return this.contentPropertyService.find(DEFAULT_EXPANSIONS).withContentId(ContentId.of((long)contentId)).withPropertyKey(propertyKey).fetch();
    }

    @Override
    public boolean isContentPropertyExists(long contentId, String propertyKey) {
        Objects.requireNonNull(propertyKey);
        return this.getContentProperty(contentId, propertyKey).isPresent();
    }

    @Override
    public void createContentProperty(Content content, String propertyKey, JsonString propertyValue) {
        Objects.requireNonNull(content);
        Objects.requireNonNull(propertyKey);
        Objects.requireNonNull(propertyValue);
        long contentId = content.getId().asLong();
        if (this.isContentPropertyExists(contentId, propertyKey)) {
            throw new ConflictException("Content property already exists");
        }
        JsonContentProperty newProperty = DefaultConfluenceContentPropertyManager.buildNewContentProperty(content, propertyKey, propertyValue);
        this.contentPropertyService.create(newProperty);
        log.debug("Created content property for contentId={}, propertyKey={}", (Object)contentId, (Object)propertyKey);
    }

    @Override
    public void updateContentProperty(Content content, String propertyKey, JsonString propertyValue) {
        Objects.requireNonNull(content);
        Objects.requireNonNull(propertyKey);
        Objects.requireNonNull(propertyValue);
        long contentId = content.getId().asLong();
        Optional<JsonContentProperty> existingPropertyOptional = this.getContentProperty(contentId, propertyKey);
        if (existingPropertyOptional.isEmpty()) {
            throw new NotFoundException("No content property found for contentId=" + contentId + " and propertyKey=" + propertyKey);
        }
        JsonContentProperty existingProperty = existingPropertyOptional.get();
        JsonContentProperty newProperty = DefaultConfluenceContentPropertyManager.buildNewContentProperty(content, propertyKey, propertyValue);
        this.contentPropertyService.update(DefaultConfluenceContentPropertyManager.getNextVersionProperty(existingProperty, newProperty));
        log.debug("Updated content property for contentId={}, propertyKey={}", (Object)contentId, (Object)propertyKey);
    }

    @Override
    public void deleteContentProperty(long contentId, String propertyKey) {
        Objects.requireNonNull(propertyKey);
        Optional<JsonContentProperty> optionalProperty = this.getContentProperty(contentId, propertyKey);
        if (optionalProperty.isPresent()) {
            this.contentPropertyService.delete(optionalProperty.get());
            log.debug("Deleted content property for contentId={}, propertyKey={}", (Object)contentId, (Object)propertyKey);
        } else {
            log.debug("No content property found for contentId={}, propertyKey={}", (Object)contentId, (Object)propertyKey);
        }
    }

    private static JsonContentProperty buildNewContentProperty(Content content, String propertyKey, JsonString propertyValue) {
        return JsonContentProperty.builder().content(content).key(propertyKey).value(propertyValue).build();
    }

    private static JsonContentProperty getNextVersionProperty(JsonContentProperty existingProperty, JsonContentProperty newContentProperty) {
        Version existingPropertyVersion = existingProperty.getVersion();
        if (Objects.isNull(existingPropertyVersion)) {
            return newContentProperty;
        }
        int nextVersionNumber = existingPropertyVersion.getNumber() + 1;
        Version nextVersion = Version.builder((Version)existingPropertyVersion).minorEdit(false).number(nextVersionNumber).build();
        return JsonContentProperty.builder((JsonContentProperty)newContentProperty).version(nextVersion).build();
    }

    @Generated
    public DefaultConfluenceContentPropertyManager(ContentPropertyService contentPropertyService) {
        this.contentPropertyService = contentPropertyService;
    }
}

