/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.manager.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import com.atlassian.confluence.api.model.content.template.ContentTemplateId;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.content.template.ContentTemplateService;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.pages.DraftManager;
import com.stiltsoft.confluence.handy.macros.macro.reminder.dto.ConfluenceContent;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultConfluenceContentManager
implements ConfluenceContentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConfluenceContentManager.class);
    private static final String NO_CONTENT_MESSAGE = "No content with id";
    private static final Expansion SPACE_EXPANSION = new Expansion("space");
    private static final Expansion[] DEF_EXPANSIONS = new Expansion[]{new Expansion("body", new Expansions(new Expansion[]{new Expansion("storage")})), new Expansion("history"), SPACE_EXPANSION, new Expansion("container", new Expansions(new Expansion[]{new Expansion("history"), new Expansion("version")})), new Expansion("version"), new Expansion("ancestors")};
    private final DraftManager draftManager;
    private final SpaceService spaceService;
    private final ContentService contentService;
    private final ContentTemplateService contentTemplateService;
    private final ContentRestrictionService contentRestrictionService;

    @Override
    public Optional<Content> getContent(@Nullable Long contentId) {
        return Optional.ofNullable(contentId).flatMap(this::fetchContent);
    }

    @Override
    public Optional<Content> getContent(@Nullable Long contentId, int version) {
        return Optional.ofNullable(contentId).flatMap(existingContentId -> this.contentService.find(DEF_EXPANSIONS).withStatus(new ContentStatus[]{ContentStatus.HISTORICAL, ContentStatus.CURRENT}).withIdAndVersion(ContentId.of((long)existingContentId), version).fetch());
    }

    @Override
    public Optional<Content> getPageContent(String spaceKey, String title) {
        return this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().flatMap(space -> this.contentService.find(DEF_EXPANSIONS).withType(new ContentType[]{ContentType.PAGE}).withSpace(new Space[]{space}).withTitle(title).fetch());
    }

    @Override
    public Optional<Content> getBlogpostContent(String spaceKey, String title, Calendar postingDay) {
        return this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().flatMap(space -> this.contentService.find(DEF_EXPANSIONS).withSpace(new Space[]{space}).withType(new ContentType[]{ContentType.BLOG_POST}).withTitle(title).withCreatedDate(LocalDateTime.ofInstant(postingDay.toInstant(), postingDay.getTimeZone().toZoneId()).toLocalDate()).fetch());
    }

    @Override
    public Optional<Content> getAttachmentContent(Content content, String filename) {
        return this.contentService.find(new Expansion[0]).withContainer((Container)content).withTitle(filename).withType(new ContentType[]{ContentType.ATTACHMENT}).fetch();
    }

    @Override
    public Optional<ConfluenceContent> getConfluenceContent(Long contentId) {
        return Optional.ofNullable(contentId).map(this::retrieve);
    }

    @Override
    public boolean isContentPresent(@Nullable Long contentId) {
        if (Objects.isNull(contentId)) {
            return false;
        }
        if (this.isConfluenceContentPresent(ContentId.of((long)contentId))) {
            return true;
        }
        if (this.isTemplatePresent(contentId)) {
            return true;
        }
        return this.isDraftPresent(contentId);
    }

    private ConfluenceContent retrieve(long contentId) {
        Content content = this.fetchContentOrNull(contentId);
        ContentTemplate contentTemplate = Objects.isNull(content) ? this.fetchContentTemplate(contentId) : null;
        return ConfluenceContent.getInstance(content, contentTemplate);
    }

    private Content fetchContentOrNull(long contentId) {
        return this.fetchContent(contentId).orElse(null);
    }

    private Optional<Content> fetchContent(long contentId) {
        return this.contentService.find(DEF_EXPANSIONS).withAnyStatus().withId(ContentId.of((long)contentId)).fetch();
    }

    private ContentTemplate fetchContentTemplate(long contentId) {
        if (contentId == 0L) {
            return null;
        }
        try {
            return (ContentTemplate)this.contentTemplateService.find(new Expansion[]{SPACE_EXPANSION}).withId(ContentTemplateId.fromLong((long)contentId)).fetchOrNull();
        }
        catch (PermissionException exception) {
            log.debug("Permission denied", (Throwable)exception);
            return null;
        }
    }

    private boolean isConfluenceContentPresent(ContentId contentId) {
        ValidationResult validationResult = this.contentRestrictionService.validator().validateGetRestrictions(contentId);
        if (validationResult.isValid()) {
            return true;
        }
        return StreamSupport.stream(validationResult.getErrors().spliterator(), false).noneMatch(error -> error.getMessage().getTranslation().contains(NO_CONTENT_MESSAGE));
    }

    private boolean isDraftPresent(long contentId) {
        return Optional.ofNullable(this.draftManager.getDraft(contentId)).isPresent();
    }

    private boolean isTemplatePresent(long contentId) {
        return Optional.ofNullable(this.fetchContentTemplate(contentId)).isPresent();
    }

    @Generated
    public DefaultConfluenceContentManager(DraftManager draftManager, SpaceService spaceService, ContentService contentService, ContentTemplateService contentTemplateService, ContentRestrictionService contentRestrictionService) {
        this.draftManager = draftManager;
        this.spaceService = spaceService;
        this.contentService = contentService;
        this.contentTemplateService = contentTemplateService;
        this.contentRestrictionService = contentRestrictionService;
    }
}

