/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.manager;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlStreamWriterTemplate;
import com.atlassian.confluence.content.render.xhtml.migration.LinkResolver;
import com.atlassian.confluence.content.render.xhtml.migration.UrlLinkMarshaller;
import com.atlassian.confluence.content.render.xhtml.migration.UrlResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.spring.container.LazyComponentReference;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class HandyLinkResolver {
    private static final Pattern HREF = Pattern.compile("<a .*?href=\"(.*?)\"");
    private final RenderedContentCleaner cleaner;
    private final ConfluenceContentManager contentManager;
    private final XhtmlContent xhtmlContent;
    private final UrlLinkMarshaller urlLinkMarshaller;
    private final LazyComponentReference<LinkResolver> xhtmlMigrationLinkResolver = new LazyComponentReference("xhtmlMigrationLinkResolver");

    public HandyLinkResolver(RenderedContentCleaner cleaner, ConfluenceContentManager contentManager, XhtmlContent xhtmlContent, XmlStreamWriterTemplate xmlStreamWriterTemplate) {
        this.cleaner = cleaner;
        this.contentManager = contentManager;
        this.xhtmlContent = xhtmlContent;
        this.urlLinkMarshaller = new UrlLinkMarshaller(xmlStreamWriterTemplate);
    }

    public HandyLink getURL(String url, ConversionContext context) {
        HandyLink handyLink = new HandyLink(url);
        if (!url.isEmpty() && context != null && context.getEntity() != null) {
            Link link = ((LinkResolver)this.xhtmlMigrationLinkResolver.get()).resolve(url, context.getPageContext());
            try {
                if (link.getDestinationResourceIdentifier() instanceof UrlResourceIdentifier) {
                    handyLink.setUrl(Streamables.writeToString((Streamable)this.urlLinkMarshaller.marshal(link, context)));
                } else {
                    handyLink.setUrl(this.xhtmlContent.convertLinkToView(link, context));
                    Content content = this.getContent(context, link.getDestinationResourceIdentifier());
                    handyLink.setContent(content);
                }
                Matcher matcher = HREF.matcher(handyLink.getUrl());
                if (matcher.find()) {
                    handyLink.setUrl(matcher.group(1));
                }
            }
            catch (XhtmlException e) {
                e.printStackTrace();
            }
        } else if (!this.cleaner.isCleanUrlAttribute(url)) {
            handyLink.setUrl("");
        }
        return handyLink;
    }

    public Content getContent(ConversionContext context, ResourceIdentifier ri) {
        String spaceKey = context.getSpaceKey();
        if (ri instanceof PageResourceIdentifier) {
            PageResourceIdentifier pri = (PageResourceIdentifier)ri;
            if (pri.getSpaceKey() != null) {
                spaceKey = pri.getSpaceKey();
            }
            return this.contentManager.getPageContent(spaceKey, pri.getTitle()).orElse(null);
        }
        if (ri instanceof BlogPostResourceIdentifier) {
            BlogPostResourceIdentifier bri = (BlogPostResourceIdentifier)ri;
            if (bri.getSpaceKey() != null) {
                spaceKey = bri.getSpaceKey();
            }
            return this.contentManager.getBlogpostContent(spaceKey, bri.getTitle(), bri.getPostingDay()).orElse(null);
        }
        return null;
    }

    public static class HandyLink {
        private String url;
        private Content content;

        public HandyLink(String url) {
            this.url = url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }
    }
}

