/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.manager;

import java.awt.Color;
import javax.swing.text.html.StyleSheet;

public class ColorHelper {
    public static String getContrastColor(String cssColor) {
        return ColorHelper.getContrast(cssColor) >= 128L ? "black" : "white";
    }

    public static long getContrast(String cssColor) {
        StyleSheet styleSheet = new StyleSheet();
        Color color = styleSheet.stringToColor(cssColor);
        return color == null ? 0L : (long)((color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000);
    }

    public static boolean colorsReadable(String cssColor1, String cssColor2) {
        return Math.abs(ColorHelper.getContrast(cssColor1) - ColorHelper.getContrast(cssColor2)) >= 125L;
    }

    public static long getColorDifference(String cssColor1, String cssColor2) {
        StyleSheet styleSheet = new StyleSheet();
        Color color1 = styleSheet.stringToColor(cssColor1);
        Color color2 = styleSheet.stringToColor(cssColor2);
        return color1 == null || color2 == null ? 0L : (long)(Math.abs(color1.getRed() - color2.getRed()) + Math.abs(color1.getBlue() - color2.getBlue()) + Math.abs(color1.getGreen() - color2.getGreen()));
    }
}

