/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.timestamp;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.pages.thumbnail.Dimensions;
import com.atlassian.confluence.util.HtmlUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class TimestampPlaceholder
implements ImagePlaceholder {
    private static final String PLACEHOLDER_SERVLET = "/plugins/servlet/timestamp/placeholder";
    private final String text;
    private final Font font;
    private final int imgWidth;
    private final int imgHeight;
    private final int txtWidth;
    private final int txtHeight;
    private BufferedImage bufferedImage;
    private Graphics2D graphics;
    private final ImageDimensions dimensions;
    private final boolean applyPlaceholderChrome;

    public TimestampPlaceholder(String text) {
        this.text = text;
        this.font = new Font("Arial", 0, 10);
        this.bufferedImage = new BufferedImage(1, 1, 1);
        this.graphics = this.bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setFont(this.font);
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        this.txtHeight = fontMetrics.getHeight();
        this.txtWidth = fontMetrics.stringWidth(text);
        this.imgWidth = this.txtWidth + 12;
        this.imgHeight = this.txtHeight + 4;
        this.dimensions = new ImageDimensions(this.imgWidth, this.imgHeight);
        this.applyPlaceholderChrome = false;
    }

    public BufferedImage getBufferedImage() {
        this.bufferedImage = new BufferedImage(this.imgWidth, this.imgHeight, 1);
        this.graphics = this.bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setColor(Color.WHITE);
        this.graphics.fillRect(0, 0, this.imgWidth, this.imgHeight);
        this.graphics.setColor(new Color(234, 244, 244));
        RoundRectangle2D.Float rectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.imgWidth, this.imgHeight, 10.0f, 10.0f);
        this.graphics.fill(rectangle);
        this.graphics.setFont(this.font);
        this.graphics.setColor(Color.BLACK);
        int yPos = this.imgHeight / 2 + this.txtHeight / 2 - this.graphics.getFontMetrics().getDescent();
        int xPos = this.imgWidth / 2 - this.txtWidth / 2;
        this.graphics.drawString(this.text, xPos, yPos);
        return this.bufferedImage;
    }

    public int getHeight() {
        return this.imgHeight;
    }

    public int getWidth() {
        return this.imgWidth;
    }

    public String getUrl() {
        return String.format("%s?%s=%s", PLACEHOLDER_SERVLET, "timestamp", HtmlUtil.urlEncode((String)this.text));
    }

    public Dimensions getDimensions() {
        return new Dimensions(this.dimensions);
    }

    public boolean applyPlaceholderChrome() {
        return this.applyPlaceholderChrome;
    }
}

