/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.timestamp;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.timestamp.TimestampPlaceholder;
import com.stiltsoft.confluence.handy.macros.util.TimeFormatter;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;

public class TimestampMacro
implements Macro,
EditorImagePlaceholder {
    private final PageManager pageManager;
    private final TimeFormatter timeFormatter;
    private final LicenseManager licenseManager;
    private final VelocityHelperService velocityHelperService;

    public TimestampMacro(PageManager pageManager, TimeFormatter timeFormatter, LicenseManager licenseManager, VelocityHelperService velocityHelperService) {
        this.pageManager = pageManager;
        this.timeFormatter = timeFormatter;
        this.licenseManager = licenseManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Map ctx = MacroUtils.defaultVelocityContext();
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("timestamp", this.getFormattedTime(params, conversionContext));
        return this.velocityHelperService.getRenderedTemplate("vm/timestamp.vm", ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> params, ConversionContext context) {
        String timestamp = this.getFormattedTime(params, context);
        return new TimestampPlaceholder(timestamp);
    }

    private String getFormattedTime(Map<String, String> params, ConversionContext context) {
        boolean hasCEO;
        String type = params.get("type");
        boolean bl = hasCEO = context != null && context.getEntity() != null;
        Date date = hasCEO && "Publishing the page".equals(type) ? this.pageManager.getVersionHistorySummaries(context.getEntity()).stream().min(Comparator.comparingInt(VersionHistorySummary::getVersion)).get().getLastModificationDate() : (hasCEO && "The last page update".equals(type) ? context.getEntity().getLastModificationDate() : new Date(Long.parseLong(params.get("time"))));
        return this.timeFormatter.format(date, params.get("format"));
    }
}

