/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.statustimestamp.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.core.ContentEntityObject;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroHistoryManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroIdMapDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroChangeDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.macro.statustimestamp.StatusTimestampMacroService;
import com.stiltsoft.confluence.handy.macros.manager.ConfluenceContentManager;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.util.TimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusTimestampMacroService
implements StatusTimestampMacroService {
    private final TimeFormatter timeFormatter;
    private final StorageService storageService;
    private final StatusMacroManager statusMacroManager;
    private final StatusMacroIdMapDao statusMacroIdMapDao;
    private final ConfluenceContentManager contentManager;
    private final StatusMacroHistoryManager statusMacroHistoryManager;

    @Override
    public String getLastStatusTimestamp(int statusMacroId, String format) {
        StatusMacroChangeDto lastStatusMacroChange = this.statusMacroHistoryManager.getLastStatusMacroChange(statusMacroId);
        return this.timeFormatter.format(lastStatusMacroChange.getModificationDate(), format);
    }

    @Override
    public boolean isStatusPresentOnPageFromStatusMacroEntity(int statusMacroId) {
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroManager.getStatusMacroByIdOrByMapping(statusMacroId);
        if (!statusMacroOptional.isPresent()) {
            return false;
        }
        StatusMacroDto statusMacro = statusMacroOptional.get();
        return this.isStatusMacroOnPage(statusMacro);
    }

    @Override
    public boolean isStatusPresentOnCurrentPage(ContentEntityObject ceo, int statusMacroId) {
        return this.storageService.isStatusMacroPresentInContentStorage(ceo, statusMacroId);
    }

    @Override
    public Optional<Integer> getNewStatusMacroId(int statusMacroId) {
        int currentMacroId = this.getLastIdFromChain(statusMacroId);
        Optional<StatusMacroDto> statusMacroOptional = this.statusMacroManager.getStatusMacroByIdOrByMapping(currentMacroId);
        if (!statusMacroOptional.isPresent()) {
            return Optional.empty();
        }
        boolean statusMacroOnPage = this.isStatusMacroOnPage(statusMacroOptional.get());
        return statusMacroOnPage ? statusMacroOptional.map(StatusMacroDto::getId) : Optional.empty();
    }

    private int getLastIdFromChain(int statusMacroId) {
        boolean flag = true;
        int currentMacroId = statusMacroId;
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        while (flag) {
            Optional<Integer> newIdOptional = this.statusMacroIdMapDao.getLastStatusMacroIdByOldId(currentMacroId);
            if (newIdOptional.isPresent() && !idsList.contains(currentMacroId)) {
                idsList.add(currentMacroId);
                currentMacroId = newIdOptional.get();
                continue;
            }
            flag = false;
        }
        return currentMacroId;
    }

    @Override
    public String createTimestampFromCurrentDate(String format) {
        return this.timeFormatter.format(new Date(), format);
    }

    @Override
    public String getCreationTimestamp(ContentEntityObject contentEntityObject, String format) {
        if (Objects.isNull(contentEntityObject)) {
            return "";
        }
        return this.timeFormatter.format(contentEntityObject.getCreationDate(), format);
    }

    private boolean isStatusMacroOnPage(StatusMacroDto statusMacro) {
        if (!statusMacro.getConfluencePageId().isPresent()) {
            return false;
        }
        int statusMacroId = statusMacro.getId();
        long confluencePageId = statusMacro.getConfluencePageId().get();
        return this.contentManager.getContent(confluencePageId).map(content -> this.storageService.isStatusMacroPresentInContentStorage((Content)content, statusMacroId)).orElse(Boolean.FALSE);
    }

    @Generated
    public DefaultStatusTimestampMacroService(TimeFormatter timeFormatter, StorageService storageService, StatusMacroManager statusMacroManager, StatusMacroIdMapDao statusMacroIdMapDao, ConfluenceContentManager contentManager, StatusMacroHistoryManager statusMacroHistoryManager) {
        this.timeFormatter = timeFormatter;
        this.storageService = storageService;
        this.statusMacroManager = statusMacroManager;
        this.statusMacroIdMapDao = statusMacroIdMapDao;
        this.contentManager = contentManager;
        this.statusMacroHistoryManager = statusMacroHistoryManager;
    }
}

