/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.statustimestamp;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.statustimestamp.StatusTimestampMacroService;
import com.stiltsoft.confluence.handy.macros.macro.timestamp.TimestampPlaceholder;
import java.util.Map;
import java.util.Optional;

public class StatusTimestampMacro
implements Macro,
EditorImagePlaceholder {
    private final LicenseManager licenseManager;
    private final VelocityHelperService velocityHelperService;
    private final StatusTimestampMacroService statusTimestampMacroService;

    public StatusTimestampMacro(LicenseManager licenseManager, VelocityHelperService velocityHelperService, StatusTimestampMacroService statusTimestampMacroService) {
        this.licenseManager = licenseManager;
        this.velocityHelperService = velocityHelperService;
        this.statusTimestampMacroService = statusTimestampMacroService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String statusTimestamp;
        Map ctx = MacroUtils.defaultVelocityContext();
        ContentEntityObject ceo = conversionContext.getEntity();
        int statusMacroId = this.getStatusMacroId(params);
        String format = params.get("format");
        boolean isPresentOnPageFromEntity = this.statusTimestampMacroService.isStatusPresentOnPageFromStatusMacroEntity(statusMacroId);
        boolean isPreview = conversionContext.getOutputType().equals("preview");
        if (isPresentOnPageFromEntity) {
            statusTimestamp = this.statusTimestampMacroService.getLastStatusTimestamp(statusMacroId, format);
        } else {
            Optional<Integer> newIdOptional = this.statusTimestampMacroService.getNewStatusMacroId(statusMacroId);
            if (newIdOptional.isPresent()) {
                int newId = newIdOptional.get();
                statusTimestamp = this.statusTimestampMacroService.getLastStatusTimestamp(newId, format);
                statusMacroId = newId;
            } else {
                boolean isPresentOnCurrentPage = this.statusTimestampMacroService.isStatusPresentOnCurrentPage(ceo, statusMacroId);
                statusTimestamp = isPresentOnCurrentPage ? this.statusTimestampMacroService.getCreationTimestamp(ceo, format) : "";
            }
        }
        ctx.put("licensed", this.licenseManager.isActive());
        ctx.put("statusMacroId", statusMacroId);
        ctx.put("format", format);
        ctx.put("statusTimestamp", statusTimestamp);
        ctx.put("export", this.isPdfOrWordExport(conversionContext.getOutputType()));
        if (isPreview && !isPresentOnPageFromEntity) {
            ctx.put("statusTimestamp", this.statusTimestampMacroService.createTimestampFromCurrentDate(format));
        }
        return this.velocityHelperService.getRenderedTemplate("vm/status-timestamp/status-timestamp-macro.vm", ctx);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> params, ConversionContext context) {
        int statusMacroId = Integer.parseInt(params.get("statusMacroId"));
        String format = params.get("format");
        String statusTimestamp = this.statusTimestampMacroService.getLastStatusTimestamp(statusMacroId, format);
        return new TimestampPlaceholder(statusTimestamp);
    }

    private int getStatusMacroId(Map<String, String> params) {
        String statusMacroId = params.get("statusMacroId");
        try {
            return Integer.parseInt(statusMacroId);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Incorrect Status ID - \"" + statusMacroId + "\". Please, enter the number in the Status ID field.");
        }
    }

    private boolean isPdfOrWordExport(String outputType) {
        return "pdf".equals(outputType) || "word".equals(outputType);
    }
}

