/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroChangeEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusSetEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.upgrade.dao.activeobjects.OldNewSetMapEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.upgrade.dao.activeobjects.OldNewStatusIdMapEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.upgrade.dao.activeobjects.StatusesEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.upgrade.dto.Status;
import com.stiltsoft.confluence.handy.macros.macro.status.upgrade.dto.Statuses;
import com.stiltsoft.confluence.handy.macros.util.JsonSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveFromJsonConfigurationUpgradeTask
implements ActiveObjectsUpgradeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MoveFromJsonConfigurationUpgradeTask.class);
    private static final int LIMIT = 500;
    private final JsonSerializer jsonSerializer;

    public MoveFromJsonConfigurationUpgradeTask(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, final ActiveObjects ao) {
        log.warn("STATUSES_CONFIG UPGRADE TASK HAS STARTED");
        if (currentVersion.isSame(ModelVersion.valueOf((String)"1"))) {
            ao.migrate(new Class[]{StatusesEntity.class, StatusMacroEntity.class, StatusMacroChangeEntity.class, StatusSetEntity.class, StatusEntity.class, OldNewSetMapEntity.class, OldNewStatusIdMapEntity.class});
            final int statusesCount = ao.count(StatusesEntity.class, Query.select());
            int statusMacroEntityCount = ao.count(StatusMacroEntity.class, Query.select());
            int statusHistoryEntityCount = ao.count(StatusMacroChangeEntity.class, Query.select());
            log.warn("STATUSES_ENTITY COUNT = {}", (Object)statusesCount);
            log.warn("STATUS_MACRO_ENTITY COUNT = {}", (Object)statusMacroEntityCount);
            log.warn("STATUS_HISTORY_ENTITY COUNT = {}", (Object)statusHistoryEntityCount);
            final AtomicInteger migratedAtomic = new AtomicInteger(0);
            ao.stream(StatusesEntity.class, Query.select((String)"ID,VALUE,NAME,OWNER,PARENT,VIEW_TYPE,WIDTH").order("ID ASC"), (EntityStreamCallback)new EntityStreamCallback<StatusesEntity, Integer>(){

                public void onRowRead(StatusesEntity entity) {
                    if (!MoveFromJsonConfigurationUpgradeTask.this.isSetMigrated(ao, entity)) {
                        StatusSetEntity set = MoveFromJsonConfigurationUpgradeTask.this.migrateSet(ao, entity);
                        MoveFromJsonConfigurationUpgradeTask.this.migrateStatuses(ao, entity, set);
                    }
                    int migrated = migratedAtomic.incrementAndGet();
                    log.warn("Migrated StatusesEntity with ID = {}, current state is: {} of {} migrated.", new Object[]{entity.getID(), migrated, statusesCount});
                }
            });
            log.warn("STATUSES_CONFIG UPGRADE TASK HAS FINISHED");
        }
    }

    private StatusSetEntity migrateSet(ActiveObjects ao, StatusesEntity entity) {
        StatusSetEntity set = (StatusSetEntity)ao.create(StatusSetEntity.class, new DBParam[]{new DBParam("NAME", (Object)entity.getName()), new DBParam("OWNER", (Object)entity.getOwner()), new DBParam("PARENT", (Object)entity.getParent()), new DBParam("VIEW_TYPE", (Object)entity.getViewType()), new DBParam("WIDTH", (Object)entity.getWidth())});
        if (entity.getID() != set.getID()) {
            StatusMacroChangeEntity[] historyEntities;
            StatusMacroEntity[] macroEntities;
            for (StatusMacroEntity macroEntity : macroEntities = (StatusMacroEntity[])ao.find(StatusMacroEntity.class, Query.select().where("CATEGORY = ?", new Object[]{entity.getID()}))) {
                macroEntity.setStatusSetId(set.getID());
                macroEntity.save();
            }
            for (StatusMacroChangeEntity historyEntity : historyEntities = (StatusMacroChangeEntity[])ao.find(StatusMacroChangeEntity.class, Query.select().where("OLD_CATEGORY = ?", new Object[]{entity.getID()}))) {
                historyEntity.setOldStatusSetId(set.getID());
                historyEntity.save();
            }
            for (StatusMacroChangeEntity historyEntity : historyEntities = (StatusMacroChangeEntity[])ao.find(StatusMacroChangeEntity.class, Query.select().where("NEW_CATEGORY = ?", new Object[]{entity.getID()}))) {
                historyEntity.setNewStatusSetId(set.getID());
                historyEntity.save();
            }
        }
        ao.create(OldNewSetMapEntity.class, new DBParam[]{new DBParam("OLD_ID", (Object)entity.getID()), new DBParam("NEW_ID", (Object)set.getID())});
        return set;
    }

    private void migrateStatuses(ActiveObjects ao, StatusesEntity entity, StatusSetEntity set) {
        Statuses statuses = this.jsonSerializer.deserialize(entity.getValue(), Statuses.class);
        int i = 0;
        for (Status status : statuses.getStatuses()) {
            StatusMacroChangeEntity[] historyEntities;
            StatusMacroEntity[] macroEntities;
            StatusEntity statusEntity = (StatusEntity)ao.create(StatusEntity.class, new DBParam[]{new DBParam("NAME", (Object)status.getTitle()), new DBParam("BG_COLOR", (Object)status.getBgColour()), new DBParam("TEXT_COLOR", (Object)(status.getTextColorEmpty() ? "" : status.getRawTextColor())), new DBParam("PRIORITY", (Object)i++), new DBParam("STATUS_SET_ID", (Object)set.getID())});
            do {
                for (StatusMacroEntity macroEntity : macroEntities = (StatusMacroEntity[])ao.find(StatusMacroEntity.class, Query.select().where("CATEGORY = ? AND STATUS = ?", new Object[]{set.getID(), status.getId()}).limit(500))) {
                    macroEntity.setStatusId(statusEntity.getID());
                    macroEntity.save();
                }
            } while (macroEntities.length == 500);
            do {
                for (StatusMacroChangeEntity historyEntity : historyEntities = (StatusMacroChangeEntity[])ao.find(StatusMacroChangeEntity.class, Query.select().where("OLD_CATEGORY = ? AND OLD_STATUS = ?", new Object[]{set.getID(), status.getId()}).limit(500))) {
                    historyEntity.setOldStatusId(statusEntity.getID());
                    historyEntity.save();
                }
            } while (historyEntities.length == 500);
            do {
                for (StatusMacroChangeEntity historyEntity : historyEntities = (StatusMacroChangeEntity[])ao.find(StatusMacroChangeEntity.class, Query.select().where("NEW_CATEGORY = ? AND NEW_STATUS = ?", new Object[]{set.getID(), status.getId()}).limit(500))) {
                    historyEntity.setNewStatusId(Long.valueOf(statusEntity.getID()));
                    historyEntity.save();
                }
            } while (historyEntities.length == 500);
            ao.create(OldNewStatusIdMapEntity.class, new DBParam[]{new DBParam("OLD_ID", (Object)status.getId()), new DBParam("NEW_ID", (Object)statusEntity.getID())});
        }
    }

    private boolean isSetMigrated(ActiveObjects ao, StatusesEntity entity) {
        Query oldNewSetMapQuery = Query.select().where("OLD_ID = ?", new Object[]{entity.getID()});
        return ao.count(OldNewSetMapEntity.class, oldNewSetMapQuery) > 0;
    }
}

