/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.StatusMacroUpdateCacheManager;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StatusMacroLazyUpdateJob
implements JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusMacroLazyUpdateJob.class);
    private final StatusMacroUpdateCacheManager statusMacroUpdateCacheManager;
    private final StorageService storageService;
    private final UserAccessor userAccessor;
    private final TransactionTemplate transactionTemplate;

    public StatusMacroLazyUpdateJob(StatusMacroUpdateCacheManager statusMacroUpdateCacheManager, StorageService storageService, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        this.statusMacroUpdateCacheManager = statusMacroUpdateCacheManager;
        this.storageService = storageService;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        final Collection<Long> pageIds = this.statusMacroUpdateCacheManager.getKeys();
        if (!pageIds.isEmpty()) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    for (Long pageId : pageIds) {
                        try {
                            for (Map<Integer, String> change : new ArrayList<Map<Integer, String>>(StatusMacroLazyUpdateJob.this.statusMacroUpdateCacheManager.get(pageId))) {
                                if (!StringUtils.defaultString((String)change.get(2)).isEmpty()) {
                                    AuthenticatedUserThreadLocal.set((ConfluenceUser)StatusMacroLazyUpdateJob.this.userAccessor.getUserByKey(new UserKey(change.get(2))));
                                } else {
                                    AuthenticatedUserThreadLocal.set(null);
                                }
                                int statusMacroId = Integer.parseInt(change.get(0));
                                String statusName = change.get(1);
                                StatusMacroLazyUpdateJob.this.storageService.updateStatusName(pageId, statusMacroId, statusName);
                                StatusMacroLazyUpdateJob.this.statusMacroUpdateCacheManager.remove(pageId, change);
                            }
                        }
                        catch (Exception e) {
                            log.error("Handy Status lazy macro update failed", (Throwable)e);
                        }
                    }
                    return null;
                }
            });
            AuthenticatedUserThreadLocal.set(null);
        }
        return null;
    }
}

