/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.job;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.PageReindexationCacheManager;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PageReindexationJob
implements JobRunner {
    private final ConfluenceIndexer indexer;
    private final PageReindexationCacheManager cacheManager;
    private final ContentEntityManager contentEntityManager;

    public PageReindexationJob(ConfluenceIndexer indexer, PageReindexationCacheManager cacheManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.indexer = indexer;
        this.cacheManager = cacheManager;
        this.contentEntityManager = contentEntityManager;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        Set<Long> ids = this.cacheManager.get();
        if (ids != null) {
            for (Long id : ids) {
                ContentEntityObject ceo = this.contentEntityManager.getById(id.longValue());
                if (ceo == null) continue;
                this.indexer.reIndex((Searchable)ceo);
            }
            this.cacheManager.remove(ids);
        }
        return null;
    }
}

