/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.entry.StatusCacheEntry;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.entry.StatusSetCacheEntry;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.util.JsonSerializer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusesService
implements StatusesService {
    private final StatusManager statusManager;
    private final StatusSetManager statusSetManager;
    private final StatusSetService statusSetService;
    private final TransactionTemplate transactionTemplate;
    private final JsonSerializer jsonSerializer;
    private final Cache<Integer, String> statusCache;
    private final Cache<Integer, String> statusSetCache;

    public DefaultStatusesService(StatusManager statusManager, StatusSetManager statusSetManager, StatusSetService statusSetService, TransactionTemplate transactionTemplate, JsonSerializer jsonSerializer, CacheManager cacheManager) {
        this.statusManager = statusManager;
        this.statusSetManager = statusSetManager;
        this.statusSetService = statusSetService;
        this.transactionTemplate = transactionTemplate;
        this.jsonSerializer = jsonSerializer;
        this.statusCache = cacheManager.getCache(StatusCacheEntry.class.getName());
        this.statusSetCache = cacheManager.getCache(StatusSetCacheEntry.class.getName());
        this.statusCache.removeAll();
        this.statusSetCache.removeAll();
    }

    @Override
    public Optional<StatusDto> getStatusFromCacheOrDB(int statusId) {
        if (this.statusCache.containsKey((Object)statusId)) {
            return Optional.ofNullable((String)this.statusCache.get((Object)statusId)).map(this::deserializeStatus);
        }
        Optional<StatusDto> statusOptional = this.statusManager.getStatus(statusId);
        statusOptional.ifPresent(status -> this.statusCache.put((Object)statusId, (Object)this.serializeStatus((StatusDto)status)));
        return statusOptional;
    }

    @Override
    public StatusSetDto createStatusSetAndRefreshCache(String name, String owner) {
        StatusSetDto statusSet = this.statusSetManager.createStatusSet(name, owner);
        this.statusSetCache.put((Object)statusSet.getId(), (Object)this.serializeStatusSet(statusSet));
        return statusSet;
    }

    @Override
    public Optional<StatusSetDto> cloneStatusSetAsPersonalAndRefreshCache(int statusSetId, String confluenceUserKey) {
        return this.statusSetService.copyStatusSetForUser(statusSetId, confluenceUserKey).map(statusSet -> {
            this.statusSetCache.put((Object)statusSet.getId(), (Object)this.serializeStatusSet((StatusSetDto)statusSet));
            return statusSet;
        });
    }

    @Override
    public void removeStatusSetAndRefreshCache(int statusSetId) {
        this.transactionTemplate.execute(() -> {
            List<Integer> statusIds = this.getStatusIdsBySetId(statusSetId);
            this.statusManager.removeStatusesBySetId(statusSetId);
            statusIds.forEach(arg_0 -> this.statusCache.remove(arg_0));
            this.statusSetManager.removeStatusSetById(statusSetId);
            this.statusSetCache.remove((Object)statusSetId);
            return null;
        });
    }

    @Override
    public void renameStatusSetAndRefreshCache(int statusSetId, String newName) {
        this.statusSetManager.renameStatusSet(statusSetId, newName).ifPresent(statusSet -> this.statusSetCache.put((Object)statusSet.getId(), (Object)this.serializeStatusSet((StatusSetDto)statusSet)));
    }

    @Override
    public void changeStatusSetViewTypeAndRefreshCache(int statusSetId, int viewType, @Nullable Integer width) {
        this.statusSetManager.updateStatusSetViewType(statusSetId, viewType, width).ifPresent(statusSet -> this.statusSetCache.put((Object)statusSet.getId(), (Object)this.serializeStatusSet((StatusSetDto)statusSet)));
    }

    @Override
    public void changeStatusSetWidthAndRefreshCache(int statusSetId, int width) {
        this.statusSetManager.updateStatusSetWidth(statusSetId, width).ifPresent(statusSet -> this.statusSetCache.put((Object)statusSet.getId(), (Object)this.serializeStatusSet((StatusSetDto)statusSet)));
    }

    @Override
    public StatusDto createStatusAndRefreshCache(int statusSetId, String name, String backgroundColor, String textColor) {
        StatusDto status = this.statusManager.createStatus(statusSetId, name, backgroundColor, textColor);
        this.statusCache.put((Object)status.getId(), (Object)this.serializeStatus(status));
        return status;
    }

    @Override
    public void removeStatusAndRefreshCache(int statusId) {
        this.statusManager.removeStatus(statusId);
        this.statusCache.remove((Object)statusId);
    }

    @Override
    public void updateStatusAndRefreshCache(int statusId, String name, String backgroundColor, String textColor) {
        this.statusManager.updateStatus(statusId, name, backgroundColor, textColor).ifPresent(status -> this.statusCache.put((Object)status.getId(), (Object)this.serializeStatus((StatusDto)status)));
    }

    @Override
    public Optional<StatusSetDto> getStatusSetFromCacheOrDB(int statusSetId) {
        if (this.statusSetCache.containsKey((Object)statusSetId)) {
            return Optional.ofNullable((String)this.statusSetCache.get((Object)statusSetId)).map(this::deserializeStatusSet);
        }
        return this.statusSetManager.getStatusSetById(statusSetId).map(statusSet -> {
            this.statusSetCache.put((Object)statusSet.getId(), (Object)this.serializeStatusSet((StatusSetDto)statusSet));
            return statusSet;
        });
    }

    @Override
    public int getCachedStatusSetWidthOrDefault(int statusSetId) {
        return this.getStatusSetFromCacheOrDB(statusSetId).map(StatusSetDto::getWidthOrDefault).orElse(88);
    }

    private List<Integer> getStatusIdsBySetId(int statusSetId) {
        return this.statusManager.getStatusesBySetId(statusSetId).stream().map(StatusDto::getId).collect(Collectors.toList());
    }

    private String serializeStatus(StatusDto status) {
        return this.jsonSerializer.serialize(new StatusCacheEntry(status));
    }

    private String serializeStatusSet(StatusSetDto statusSet) {
        return this.jsonSerializer.serialize(new StatusSetCacheEntry(statusSet));
    }

    private StatusDto deserializeStatus(String serializedStatusCacheEntry) {
        return this.jsonSerializer.deserialize(serializedStatusCacheEntry, StatusCacheEntry.class).toStatusDto();
    }

    private StatusSetDto deserializeStatusSet(String serializedStatusSetCacheEntry) {
        return this.jsonSerializer.deserialize(serializedStatusSetCacheEntry, StatusSetCacheEntry.class).toStatusSetDto();
    }
}

