/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetOwner;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.StatusSetRestEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusSetService
implements StatusSetService {
    private final UserAccessor userAccessor;
    private final StatusManager statusManager;
    private final StatusSetManager statusSetManager;
    private final TransactionTemplate transactionTemplate;

    public DefaultStatusSetService(UserAccessor userAccessor, StatusManager statusManager, StatusSetManager statusSetManager, TransactionTemplate transactionTemplate) {
        this.userAccessor = userAccessor;
        this.statusManager = statusManager;
        this.statusSetManager = statusSetManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public Optional<StatusSetDto> copyStatusSetForUser(int statusSetId, String userKey) {
        String personalOwner = StatusSetOwner.getPersonalOwner(userKey);
        return (Optional)this.transactionTemplate.execute(() -> this.statusSetManager.getStatusSetById(statusSetId).map(sourceStatusSet -> this.statusSetManager.createStatusSet(sourceStatusSet.getName(), personalOwner, sourceStatusSet.getId(), sourceStatusSet.getViewType(), sourceStatusSet.getWidth())).map(copiedStatusSet -> {
            this.statusManager.copyStatusesByStatusSetId(statusSetId, copiedStatusSet.getId());
            return copiedStatusSet;
        }));
    }

    @Override
    public Optional<StatusDto> getFirstAvailableStatus(@Nullable String spaceKey, @Nullable String userKey) {
        List<StatusSetDto> spaceStatusSets;
        List<StatusSetDto> personalStatusSets;
        Optional<StatusDto> statusOptional;
        if (Objects.nonNull(userKey) && (statusOptional = this.getFirstAvailableStatusFromSets(personalStatusSets = this.statusSetManager.getPersonalStatusSets(userKey))).isPresent()) {
            return statusOptional;
        }
        if (Objects.nonNull(spaceKey) && (statusOptional = this.getFirstAvailableStatusFromSets(spaceStatusSets = this.statusSetManager.getSpaceStatusSets(spaceKey))).isPresent()) {
            return statusOptional;
        }
        List<StatusSetDto> globalStatusSets = this.statusSetManager.getGlobalStatusSets();
        return this.getFirstAvailableStatusFromSets(globalStatusSets);
    }

    @Override
    public List<StatusSetRestEntity> getStatusSetRestEntities(int statusSetId, String ... owners) {
        List<StatusSetRestEntity> statusSetRestEntities = this.getStatusSetRestEntitiesByOwners(owners);
        boolean isCurrentStatusSetPresent = statusSetRestEntities.stream().anyMatch(statusSetRestEntity -> statusSetRestEntity.getId() == statusSetId);
        if (statusSetId == 0 || isCurrentStatusSetPresent) {
            return statusSetRestEntities;
        }
        Optional<StatusSetDto> statusSetOptional = this.statusSetManager.getStatusSetById(statusSetId);
        if (statusSetOptional.isPresent()) {
            StatusSetDto statusSet = statusSetOptional.get();
            String setName = this.getPersonalStatusSetFormattedName(statusSet);
            boolean isEmpty = this.statusManager.countStatusesBySetId(statusSetId) == 0;
            statusSetRestEntities.add(new StatusSetRestEntity(statusSetId, setName, statusSet.getOwner(), statusSet.getParentId(), isEmpty, statusSet.getViewType(), statusSet.getWidth()));
        } else {
            statusSetRestEntities.add(new StatusSetRestEntity(statusSetId));
        }
        return statusSetRestEntities;
    }

    private List<StatusSetRestEntity> getStatusSetRestEntitiesByOwners(String ... owners) {
        ArrayList<StatusSetRestEntity> categories = new ArrayList<StatusSetRestEntity>();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        for (String owner : owners) {
            ArrayList<StatusSetRestEntity> ownerCategories = new ArrayList<StatusSetRestEntity>();
            Object prefix = "";
            if (owners.length > 1) {
                if (owner.startsWith("user:")) {
                    prefix = user == null ? "" : user.getFullName() + ": ";
                } else if (owner.startsWith("space:")) {
                    prefix = owner.replace("space:", "") + ": ";
                }
            }
            List<StatusSetDto> statusSets = owner.startsWith("space:") ? this.statusSetManager.getStatusSetsBySpaceOwner(owner) : this.statusSetManager.getStatusSetsByOwner(owner);
            for (StatusSetDto statusSet : statusSets) {
                int statusesCount = this.statusManager.countStatusesBySetId(statusSet.getId());
                boolean isEmptyStatusSet = statusesCount == 0;
                String statusSetName = (String)prefix + statusSet.getName();
                ownerCategories.add(new StatusSetRestEntity(statusSet.getId(), statusSetName, statusSet.getOwner(), statusSet.getParentId(), isEmptyStatusSet, statusSet.getViewType(), statusSet.getWidth()));
            }
            Collections.sort(ownerCategories);
            categories.addAll(ownerCategories);
        }
        return categories;
    }

    private Optional<StatusDto> getFirstAvailableStatusFromSets(List<StatusSetDto> statusSets) {
        List<Integer> statusSetIds = statusSets.stream().map(StatusSetDto::getId).collect(Collectors.toList());
        return this.statusManager.getFirstAvailableStatusFromSets(statusSetIds);
    }

    private String getPersonalStatusSetFormattedName(StatusSetDto statusSet) {
        String userFullName = this.getUserFullNameOfPersonalSet(statusSet);
        return String.format("%s: %s", userFullName, statusSet.getName());
    }

    private String getUserFullNameOfPersonalSet(StatusSetDto statusSet) {
        String userKey = statusSet.getOwner().replace("user:", "");
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
        return Objects.isNull(user) ? "Unknown" : user.getFullName();
    }
}

