/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetOwner;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusSetDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusSetEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusSetManager
implements StatusSetManager {
    private final StatusSetDao dao;

    public DefaultStatusSetManager(StatusSetDao dao) {
        this.dao = dao;
    }

    @Override
    public Optional<StatusSetDto> getStatusSetById(int statusSetId) {
        return this.dao.getStatusSetEntityById(statusSetId).map(StatusSetDto::new);
    }

    @Override
    public List<StatusSetDto> getGlobalStatusSets() {
        return this.getStatusSetsByOwner("global");
    }

    @Override
    public List<StatusSetDto> getSpaceStatusSets(String spaceKey) {
        String spaceOwner = StatusSetOwner.getSpaceOwner(spaceKey);
        return this.getStatusSetsBySpaceOwner(spaceOwner);
    }

    @Override
    public List<StatusSetDto> getStatusSetsBySpaceOwner(String spaceOwner) {
        return this.toSortedDTO(this.dao.getStatusSetEntitiesBySpaceOwner(spaceOwner));
    }

    @Override
    public List<StatusSetDto> getPersonalStatusSets(String userKey) {
        String personalOwner = StatusSetOwner.getPersonalOwner(userKey);
        return this.getStatusSetsByOwner(personalOwner);
    }

    @Override
    public List<StatusSetDto> getStatusSetsByOwner(String owner) {
        return this.toSortedDTO(this.dao.getStatusSetEntitiesByOwner(owner));
    }

    @Override
    public StatusSetDto createStatusSet(String name, String owner) {
        return this.createStatusSet(name, owner, null, null, null);
    }

    @Override
    public StatusSetDto createStatusSet(String name, String owner, @Nullable Integer parentId, @Nullable Integer viewType, @Nullable Integer width) {
        StatusSetEntity entity = this.dao.createStatusSetEntity(name, owner, parentId, viewType, width);
        return new StatusSetDto(entity);
    }

    @Override
    public void removeStatusSetById(int statusSetId) {
        this.dao.removeStatusSetEntityById(statusSetId);
    }

    @Override
    public int getStatusSetWidthOrDefault(int statusSetId) {
        return this.getStatusSetById(statusSetId).map(StatusSetDto::getWidthOrDefault).orElse(88);
    }

    @Override
    public Optional<StatusSetDto> renameStatusSet(int statusSetId, String newName) {
        return this.dao.getStatusSetEntityById(statusSetId).map(statusSetEntity -> {
            statusSetEntity.setName(newName);
            statusSetEntity.save();
            return statusSetEntity;
        }).map(StatusSetDto::new);
    }

    @Override
    public Optional<StatusSetDto> updateStatusSetViewType(int statusSetId, int viewType, @Nullable Integer width) {
        return this.dao.getStatusSetEntityById(statusSetId).map(statusSetEntity -> {
            statusSetEntity.setViewType(viewType);
            statusSetEntity.setWidth(width);
            statusSetEntity.save();
            return statusSetEntity;
        }).map(StatusSetDto::new);
    }

    @Override
    public Optional<StatusSetDto> updateStatusSetWidth(int statusSetId, int width) {
        return this.dao.getStatusSetEntityById(statusSetId).map(statusSetEntity -> {
            statusSetEntity.setWidth(width);
            statusSetEntity.save();
            return statusSetEntity;
        }).map(StatusSetDto::new);
    }

    private List<StatusSetDto> toSortedDTO(List<StatusSetEntity> entities) {
        return entities.stream().map(StatusSetDto::new).sorted().collect(Collectors.toList());
    }
}

