/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusManager
implements StatusManager {
    private final StatusDao dao;

    public DefaultStatusManager(StatusDao dao) {
        this.dao = dao;
    }

    @Override
    public Optional<StatusDto> getStatus(int statusId) {
        return this.dao.getStatusEntity(statusId).map(StatusDto::new);
    }

    @Override
    public Collection<StatusDto> getStatusesBySetId(int statusSetId) {
        return this.dao.getStatusEntitiesBySetId(statusSetId).stream().map(StatusDto::new).collect(Collectors.toList());
    }

    @Override
    public StatusDto createStatus(int statusSetId, String name, String backgroundColor, String textColor) {
        int statusesCount = this.dao.countStatusesBySetId(statusSetId);
        StatusEntity createdStatus = this.dao.createStatusEntity(statusSetId, name, backgroundColor, textColor, statusesCount);
        return new StatusDto(createdStatus);
    }

    @Override
    public void removeStatus(int statusId) {
        this.dao.removeStatusEntity(statusId);
    }

    @Override
    public Optional<StatusDto> updateStatus(int statusId, String name, String backgroundColor, String textColor) {
        return this.dao.getAndUpdateStatusEntity(statusId, name, backgroundColor, textColor).map(StatusDto::new);
    }

    @Override
    public void sortStatuses(int statusSetId, List<Integer> orderedStatusIds) {
        this.dao.sortStatusEntities(statusSetId, orderedStatusIds);
    }

    @Override
    public void copyStatusesByStatusSetId(int sourceStatusSetId, int targetStatusSetId) {
        List<StatusEntity> sourceStatusEntities = this.dao.getStatusEntitiesBySetId(sourceStatusSetId);
        for (int i = 0; i < sourceStatusEntities.size(); ++i) {
            StatusEntity source = sourceStatusEntities.get(i);
            this.dao.createStatusEntity(targetStatusSetId, source.getName(), source.getBackgroundColor(), source.getTextColor(), i);
        }
    }

    @Override
    public Optional<StatusDto> getFirstAvailableStatusFromSets(List<Integer> statusSetIds) {
        if (statusSetIds.isEmpty()) {
            return Optional.empty();
        }
        return this.dao.getFirstAvailableStatusEntityFromSets(statusSetIds).map(StatusDto::new);
    }

    @Override
    public int countStatusesBySetId(int statusSetId) {
        return this.dao.countStatusesBySetId(statusSetId);
    }

    @Override
    public void removeStatusesBySetId(int statusSetId) {
        this.dao.removeStatusEntitiesBySetId(statusSetId);
    }
}

