/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.core.bean.EntityObject;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroUsageService;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetUsageDto;
import com.stiltsoft.confluence.handy.macros.service.HandyPermissionService;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroUsageService
implements StatusMacroUsageService {
    private static final int USAGE_LIMIT = 50;
    private final PageManager pageManager;
    private final StorageService storageService;
    private final StatusMacroManager statusMacroManager;
    private final HandyPermissionService handyPermissionService;

    @Override
    public StatusSetUsageDto getStatusSetUsage(int statusSetId) {
        Map<Long, AbstractPage> pages = this.getStatusMacroUsage(offset -> this.statusMacroManager.getStatusMacrosWhereConfluencePageIdIsNotNull(statusSetId, (int)offset, 50));
        return this.toStatusMacroUsageDto(pages);
    }

    @Override
    public StatusSetUsageDto getStatusUsage(int statusSetId, int statusId) {
        Map<Long, AbstractPage> pages = this.getStatusMacroUsage(offset -> this.statusMacroManager.getStatusMacrosWhereConfluencePageIdIsNotNull(statusSetId, statusId, (int)offset, 50));
        return this.toStatusMacroUsageDto(pages);
    }

    private StatusSetUsageDto toStatusMacroUsageDto(Map<Long, AbstractPage> pages) {
        Map<Long, AbstractPage> permittedPageById = pages.values().stream().filter(this.handyPermissionService::hasCurrentUserEntityReadPermission).collect(Collectors.toMap(EntityObject::getId, page -> page));
        int restrictedPagesCount = pages.size() - permittedPageById.size();
        return new StatusSetUsageDto(restrictedPagesCount, permittedPageById);
    }

    private void findPagesForStatusMacro(Map<Long, AbstractPage> pages, Collection<StatusMacroDto> statusMacrosWhereConfluencePageIdIsNotNull) {
        for (StatusMacroDto statusMacro : statusMacrosWhereConfluencePageIdIsNotNull) {
            AbstractPage page;
            long confluencePageId = statusMacro.getConfluencePageId().get();
            if (pages.containsKey(confluencePageId) || (page = this.pageManager.getAbstractPage(confluencePageId)) == null || !this.storageService.isStatusMacroPresentInContentStorage((ContentEntityObject)page, statusMacro.getId())) continue;
            pages.put(confluencePageId, page);
        }
    }

    private Map<Long, AbstractPage> getStatusMacroUsage(Function<Integer, Collection<StatusMacroDto>> statusMacroSupplier) {
        HashMap<Long, AbstractPage> pageById = new HashMap<Long, AbstractPage>();
        for (int offset = 0; pageById.size() < 50 && offset < 300; offset += 50) {
            Collection<StatusMacroDto> statusMacros = statusMacroSupplier.apply(offset);
            this.findPagesForStatusMacro(pageById, statusMacros);
            if (statusMacros.size() < 50) break;
        }
        return pageById;
    }

    @Generated
    public DefaultStatusMacroUsageService(PageManager pageManager, StorageService storageService, StatusMacroManager statusMacroManager, HandyPermissionService handyPermissionService) {
        this.pageManager = pageManager;
        this.storageService = storageService;
        this.statusMacroManager = statusMacroManager;
        this.handyPermissionService = handyPermissionService;
    }
}

