/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.handy.macros.license.LicenseManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusLabelManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroHistoryManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.PageReindexationCacheManager;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.StatusMacroUpdateCacheManager;
import com.stiltsoft.confluence.handy.macros.macro.status.cache.entry.StatusMacroCacheEntry;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroIdMapDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.option.StatusDropdownItemRestEntity;
import com.stiltsoft.confluence.handy.macros.storage.StorageService;
import com.stiltsoft.confluence.handy.macros.util.ContentEntityUtil;
import com.stiltsoft.confluence.handy.macros.util.JsonSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroService
implements StatusMacroService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusMacroService.class);
    private final StatusManager statusManager;
    private final LicenseManager licenseManager;
    private final StorageService storageService;
    private final JsonSerializer jsonSerializer;
    private final StatusSetManager statusSetManager;
    private final StatusMacroManager statusMacroManager;
    private final StatusLabelManager statusLabelManager;
    private final StatusMacroIdMapDao statusMacroIdMapDao;
    private final VelocityHelperService velocityHelperService;
    private final StatusMacroHistoryManager statusMacroHistoryManager;
    private final PageReindexationCacheManager reindexationCacheManager;
    private final StatusMacroUpdateCacheManager statusMacroUpdateCacheManager;
    private final Cache<String, String> cache;

    public DefaultStatusMacroService(StatusManager statusManager, LicenseManager licenseManager, StorageService storageService, JsonSerializer jsonSerializer, StatusSetManager statusSetManager, StatusMacroManager statusMacroManager, StatusLabelManager statusLabelManager, StatusMacroIdMapDao statusMacroIdMapDao, VelocityHelperService velocityHelperService, StatusMacroHistoryManager statusMacroHistoryManager, PageReindexationCacheManager reindexationCacheManager, StatusMacroUpdateCacheManager statusMacroUpdateCacheManager, CacheManager cacheManager) {
        this.statusManager = statusManager;
        this.licenseManager = licenseManager;
        this.storageService = storageService;
        this.jsonSerializer = jsonSerializer;
        this.statusSetManager = statusSetManager;
        this.statusMacroManager = statusMacroManager;
        this.statusLabelManager = statusLabelManager;
        this.statusMacroIdMapDao = statusMacroIdMapDao;
        this.velocityHelperService = velocityHelperService;
        this.statusMacroHistoryManager = statusMacroHistoryManager;
        this.reindexationCacheManager = reindexationCacheManager;
        this.statusMacroUpdateCacheManager = statusMacroUpdateCacheManager;
        CacheSettings cacheSettings = new CacheSettingsBuilder().maxEntries(10000).expireAfterAccess(14L, TimeUnit.DAYS).build();
        this.cache = cacheManager.getCache(StatusMacroCacheEntry.class.getName(), null, cacheSettings);
        this.cache.removeAll();
    }

    @Override
    public Optional<StatusMacroDto> getCachedStatusMacroOrCreateDraftCopyAndCache(int statusMacroId, @Nullable Long confluencePageId) {
        String statusMacroCacheKey;
        log.debug("statusMacroId = {}, confluencePageId = {}.", (Object)statusMacroId, (Object)confluencePageId);
        if (Objects.nonNull(confluencePageId) && this.cache.containsKey((Object)(statusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, statusMacroId)))) {
            return Optional.ofNullable((String)this.cache.get((Object)statusMacroCacheKey)).map(this::deserializeStatusMacro).map(DefaultStatusMacroService.logCachedStatusMacro(statusMacroCacheKey));
        }
        return this.statusMacroManager.getStatusMacroByIdAndConfluencePageIdOrCreateDraftCopy(statusMacroId, confluencePageId).map(draftStatusMacro -> {
            log.debug("draftStatusMacro = {}.", draftStatusMacro);
            if (confluencePageId != null) {
                String statusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, draftStatusMacro.getId());
                this.cache.put((Object)statusMacroCacheKey, (Object)this.serializeStatusMacro((StatusMacroDto)draftStatusMacro));
                log.debug("Cached with key = {}.", (Object)statusMacroCacheKey);
            }
            return draftStatusMacro;
        });
    }

    @Override
    public Optional<StatusMacroDto> getCachedStatusMacroOrFindWithMapping(int statusMacroId, @Nullable Long confluencePageId) {
        log.debug("statusMacroId = {}, confluencePageId = {}.", (Object)statusMacroId, (Object)confluencePageId);
        if (Objects.isNull(confluencePageId)) {
            return this.statusMacroManager.getStatusMacroByIdOrByMapping(statusMacroId);
        }
        String statusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, statusMacroId);
        if (this.cache.containsKey((Object)statusMacroCacheKey)) {
            return Optional.ofNullable((String)this.cache.get((Object)statusMacroCacheKey)).map(this::deserializeStatusMacro).map(DefaultStatusMacroService.logCachedStatusMacro(statusMacroCacheKey));
        }
        return this.statusMacroManager.getStatusMacroByIdAndPageIdOrFindWithMapping(statusMacroId, confluencePageId);
    }

    @Override
    public Optional<Integer> changeStatusIdForStatusMacroAndRefreshCache(int macroId, int statusId, long contentId, @Nullable ConfluenceUser author) {
        log.debug("macroId = {}, statusId = {}, contentId = {}, author = {}.", new Object[]{macroId, statusId, contentId, author});
        return this.changeStatusIdForStatusMacro(macroId, statusId, contentId, author).map(statusMacro -> {
            log.debug("statusMacro = {}.", statusMacro);
            String newStatusMacroCacheKey = this.getStatusMacroCacheKey(contentId, statusMacro.getId());
            this.cache.put((Object)newStatusMacroCacheKey, (Object)this.serializeStatusMacro((StatusMacroDto)statusMacro));
            return statusMacro.getId();
        });
    }

    @Override
    public Optional<Integer> updateStatusMacroAndRefreshCache(int statusMacroId, int statusSetId, long statusId, boolean outline, boolean labelled, String prefix, @Nullable Long confluencePageId) {
        log.debug("statusMacroId = {}, statusSetId = {}, statusId = {}, outline = {}, labelled = {}, prefix = {}, confluencePageId = {}.", new Object[]{statusMacroId, statusSetId, statusId, outline, labelled, prefix, confluencePageId});
        return this.statusMacroManager.updateStatusMacro(statusMacroId, statusSetId, statusId, outline, labelled, prefix, confluencePageId).map(statusMacro -> {
            log.debug("statusMacro = {}.", statusMacro);
            if (Objects.nonNull(confluencePageId)) {
                String newStatusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, statusMacro.getId());
                this.cache.put((Object)newStatusMacroCacheKey, (Object)this.serializeStatusMacro((StatusMacroDto)statusMacro));
            }
            return statusMacro.getId();
        });
    }

    @Override
    public StatusMacroDto createStatusMacroAndCache(int statusSetId, long statusId, boolean outline, @Nullable Long confluencePageId, boolean labelled, String labelPrefix, boolean isDraft) {
        log.debug("statusSetId = {}, statusId = {}, outline = {}, confluencePageId = {}, labelled = {}, labelPrefix = {}, isDraft = {}.", new Object[]{statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, isDraft});
        StatusMacroDto statusMacro = this.statusMacroManager.createStatusMacro(statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, isDraft);
        log.debug("statusMacro = {}.", (Object)statusMacro);
        if (Objects.nonNull(confluencePageId)) {
            String statusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, statusMacro.getId());
            this.cache.put((Object)statusMacroCacheKey, (Object)this.serializeStatusMacro(statusMacro));
        }
        return statusMacro;
    }

    @Override
    public Map<String, Map<StatusMacroDto, List<Integer>>> updateLabelAndRefreshCache(long confluencePageId, String label) {
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        log.debug("confluencePageId = {}, label = {}, author = {}.", new Object[]{confluencePageId, label, author});
        Map<String, Map<StatusMacroDto, List<Integer>>> idsMap = this.updateLabel(confluencePageId, label, author);
        for (Map.Entry<String, Map<StatusMacroDto, List<Integer>>> labelIds : idsMap.entrySet()) {
            for (Map.Entry<StatusMacroDto, List<Integer>> entry : labelIds.getValue().entrySet()) {
                for (Integer id : entry.getValue()) {
                    String statusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, id);
                    this.cache.put((Object)statusMacroCacheKey, (Object)this.serializeStatusMacro(entry.getKey()));
                }
            }
        }
        return idsMap;
    }

    @Override
    public void createStatusMacrosForCreatedContent(ContentEntityObject ceo) {
        this.storageService.handleStatusMacroDefinitions(ceo, macroDefinition -> {
            int statusMacroId = Integer.parseInt(macroDefinition.getParameter("id"));
            long contentId = ceo.getId();
            log.debug("statusMacroId = {}, pageId = {}.", (Object)statusMacroId, (Object)contentId);
            this.getCachedStatusMacroOrCreateDraftCopyAndCache(statusMacroId, contentId).ifPresent(statusMacro -> {
                log.debug("statusMacroIdOld = {}, statusMacroIdNew = {}, pageId = {}.", new Object[]{statusMacroId, statusMacro.getId(), contentId});
                if (statusMacro.getDraftId().isPresent()) {
                    ConfluenceUser author = ContentEntityUtil.getContentCreator(ceo);
                    this.publishStatusMacroDraftAndCache((StatusMacroDto)statusMacro, statusMacroId, contentId, author);
                }
            });
        });
    }

    @Override
    public void publishStatusMacrosForUpdatedContent(ContentEntityObject ceo, ConfluenceUser lastModifier) {
        this.storageService.handleStatusMacroDefinitions(ceo, macroDefinition -> {
            int statusMacroId = Integer.parseInt(macroDefinition.getParameter("id"));
            long contentId = ceo.getId();
            log.debug("statusMacroId = {}, pageId = {}.", (Object)statusMacroId, (Object)contentId);
            this.getCachedStatusMacroOrFindWithMapping(statusMacroId, contentId).ifPresent(statusMacro -> {
                log.debug("statusMacroIdOld = {}, statusMacroIdNew = {}, pageId = {}.", new Object[]{statusMacroId, statusMacro.getId(), contentId});
                if (statusMacro.getDraftId().isPresent()) {
                    this.publishStatusMacroDraftAndCache((StatusMacroDto)statusMacro, statusMacroId, contentId, lastModifier);
                }
            });
        });
    }

    @Override
    public int updateMacroParamsInContentStorageMarkup(long contentId, @Nullable Content content, int currentMacroId, int newMacroId, String statusName) {
        int pageVersion;
        block5: {
            pageVersion = 0;
            try {
                if (newMacroId != currentMacroId) {
                    this.storageService.replaceStatusMacroIdInContentStorage(contentId, currentMacroId, newMacroId);
                }
                if (Objects.nonNull(content) && content.getType().in(new BaseApiEnum[]{ContentType.PAGE, ContentType.BLOG_POST, ContentType.COMMENT})) {
                    if (this.statusMacroUpdateCacheManager.contains(contentId)) {
                        throw new Exception("Need to keep status macro update order");
                    }
                    pageVersion = this.storageService.updateStatusName(contentId, newMacroId, statusName);
                }
            }
            catch (Exception e) {
                if (!Objects.nonNull(content) || !content.getType().in(new BaseApiEnum[]{ContentType.PAGE, ContentType.BLOG_POST, ContentType.COMMENT})) break block5;
                this.statusMacroUpdateCacheManager.add(contentId, currentMacroId, statusName);
                if (newMacroId == currentMacroId) break block5;
                this.statusMacroUpdateCacheManager.add(contentId, newMacroId, statusName);
            }
        }
        this.reindexationCacheManager.add(contentId);
        return pageVersion;
    }

    @Override
    public List<StatusDropdownItemRestEntity> getStatusDropdownItemRestEntities(StatusMacroDto statusMacro, int originalStatusMacroId, int limit, String query, boolean searchInput) {
        if (!this.licenseManager.isActive()) {
            String licenseItemContent = this.velocityHelperService.getRenderedTemplate("/vm/status/status-license.vm", MacroUtils.defaultVelocityContext());
            return Collections.singletonList(new StatusDropdownItemRestEntity(licenseItemContent));
        }
        Map params = MacroUtils.defaultVelocityContext();
        params.put("licensed", true);
        params.put("outline", statusMacro.isOutline());
        params.put("macroId", originalStatusMacroId);
        params.put("pageId", statusMacro.getConfluencePageIdOrNegativeValue());
        params.put("important", "");
        params.put("view", 0);
        this.statusSetManager.getStatusSetById(statusMacro.getStatusSetId()).ifPresent(statusSet -> {
            params.put("view", statusSet.getViewType());
            params.put("width", statusSet.getWidthOrDefault());
        });
        ArrayList<StatusDropdownItemRestEntity> dropdownItems = new ArrayList<StatusDropdownItemRestEntity>(limit + 1);
        Collection<StatusDto> statuses = this.statusManager.getStatusesBySetId(statusMacro.getStatusSetId());
        if (searchInput && statuses.size() > limit) {
            params.put("total", statuses.size());
            params.put("shown", limit);
            String itemContent = this.velocityHelperService.getRenderedTemplate("/vm/status/status-search-box.vm", params);
            dropdownItems.add(new StatusDropdownItemRestEntity(itemContent, true));
        }
        String searchLC = query.toLowerCase();
        statuses.stream().filter(status -> status.getName().toLowerCase().contains(searchLC)).limit(limit).forEach(status -> {
            params.put("status", status);
            String statusItemContent = this.velocityHelperService.getRenderedTemplate("/vm/status/status-option.vm", params);
            dropdownItems.add(new StatusDropdownItemRestEntity(statusItemContent));
        });
        return dropdownItems;
    }

    private Optional<StatusMacroDto> changeStatusIdForStatusMacro(int statusMacroId, int statusId, long confluencePageId, @Nullable ConfluenceUser author) {
        log.debug("statusMacroId = {}, statusId = {}, confluencePageId = {}, author = {}.", new Object[]{statusMacroId, statusId, confluencePageId, author});
        return this.statusMacroManager.getStatusMacroByIdAndPageIdOrFindWithMapping(statusMacroId, confluencePageId).map(statusMacro -> {
            log.debug("statusMacro = {}.", statusMacro);
            StatusDto status = this.statusManager.getStatus(statusMacro.extractStatusId()).get();
            log.debug("status = {}.", (Object)status);
            this.statusLabelManager.removeLabel((StatusMacroDto)statusMacro, status);
            this.statusMacroHistoryManager.createStatusMacroChange(statusMacro.getId(), statusMacro.getId(), statusMacro.getStatusSetId(), Long.valueOf(statusId), statusMacro.isOutline(), author);
            StatusMacroDto updatedStatusMacro = this.statusMacroManager.changeStatusId(statusMacro.getId(), statusId);
            log.debug("updatedStatusMacro = {}.", (Object)updatedStatusMacro);
            StatusDto newStatus = this.statusManager.getStatus(statusId).get();
            log.debug("newStatus = {}.", (Object)newStatus);
            this.statusLabelManager.addLabel(updatedStatusMacro, newStatus);
            return updatedStatusMacro;
        });
    }

    private Map<String, Map<StatusMacroDto, List<Integer>>> updateLabel(long confluencePageId, String label, @Nullable ConfluenceUser author) {
        log.debug("confluencePageId = {}, label = {}, author = {}.", new Object[]{confluencePageId, label, author});
        HashMap<String, Map<StatusMacroDto, List<Integer>>> idsMap = new HashMap<String, Map<StatusMacroDto, List<Integer>>>();
        HashMap statusesBySetId = new HashMap();
        Collection<StatusMacroDto> statusMacros = this.statusMacroManager.getStatusMacrosForPageWithLabel(confluencePageId);
        statusMacros.forEach(statusMacro -> {
            Collection statuses;
            int statusSetId;
            String status = label;
            if (statusMacro.isLabeled()) {
                status = label.replace(statusMacro.getLabelPrefix(), "");
                if (!statusMacro.getLabelPrefix().equals(label.replace(status, ""))) {
                    return;
                }
            }
            if (statusesBySetId.containsKey(statusSetId = statusMacro.getStatusSetId())) {
                statuses = (Collection)statusesBySetId.get(statusSetId);
            } else {
                statuses = this.statusManager.getStatusesBySetId(statusSetId);
                statusesBySetId.put(statusSetId, statuses);
            }
            if (statuses != null) {
                StatusDto statusEntity;
                Optional<StatusDto> statusEntityOptional = this.findStatusByName(statuses, status);
                if (!statusEntityOptional.isPresent()) {
                    status = status.replaceAll("_", " ");
                    statusEntityOptional = this.findStatusByName(statuses, status);
                }
                if (statusEntityOptional.isPresent() && !Long.valueOf((statusEntity = statusEntityOptional.get()).getId()).equals(statusMacro.getStatusId())) {
                    Optional<StatusMacroDto> statusMacroForUpdateOptional;
                    if (!idsMap.containsKey(status)) {
                        idsMap.put(status, new HashMap());
                    }
                    if ((statusMacroForUpdateOptional = this.statusMacroManager.getStatusMacroByIdOrByMapping(statusMacro.getId())).isPresent()) {
                        StatusMacroDto statusMacroForUpdate = statusMacroForUpdateOptional.get();
                        this.statusMacroHistoryManager.createStatusMacroChange(statusMacroForUpdate.getId(), statusMacroForUpdate.getId(), statusMacroForUpdate.getStatusSetId(), Long.valueOf(statusEntity.getId()), statusMacroForUpdate.isOutline(), author);
                        this.statusMacroManager.changeStatusId(statusMacroForUpdate.getId(), statusEntity.getId());
                        List<Integer> ids = this.statusMacroIdMapDao.getOldStatusMacroIds(statusMacro.getId(), confluencePageId);
                        ids.add(statusMacro.getId());
                        StatusMacroDto actualStatusMacro = this.statusMacroManager.getStatusMacro(statusMacro.getId());
                        ((Map)idsMap.get(status)).put(actualStatusMacro, ids);
                    }
                }
            }
        });
        return idsMap;
    }

    private void publishStatusMacroDraftAndCache(StatusMacroDto draftStatusMacro, int statusMacroId, @Nullable Long confluencePageId, @Nullable ConfluenceUser author) {
        log.debug("draftStatusMacro = {}, statusMacroId = {}, confluencePageId = {}, author = {}.", new Object[]{draftStatusMacro, statusMacroId, confluencePageId, author});
        StatusMacroDto statusMacro = this.publishDraft(draftStatusMacro, confluencePageId, author);
        log.debug("statusMacro = {}.", (Object)statusMacro);
        if (Objects.nonNull(confluencePageId)) {
            String statusMacroCacheKey = this.getStatusMacroCacheKey(confluencePageId, statusMacroId);
            this.cache.put((Object)statusMacroCacheKey, (Object)this.serializeStatusMacro(statusMacro));
        }
    }

    private StatusMacroDto publishDraft(StatusMacroDto statusMacro, @Nullable Long confluencePageId, @Nullable ConfluenceUser author) {
        log.debug("statusMacro = {}, confluencePageId = {}, author = {}.", new Object[]{statusMacro, confluencePageId, author});
        if (!statusMacro.getDraftId().isPresent()) {
            return statusMacro;
        }
        if (statusMacro.getId() == statusMacro.getDraftId().get().intValue()) {
            this.statusMacroManager.unsetStatusMacroDraftId(statusMacro.getId());
            this.statusMacroHistoryManager.createStatusMacroChange(statusMacro.getId(), statusMacro.getId(), null, null, null, author);
            this.statusManager.getStatus(statusMacro.extractStatusId()).ifPresent(status -> this.statusLabelManager.addLabel(statusMacro, (StatusDto)status));
            return this.statusMacroManager.getStatusMacro(statusMacro.getId());
        }
        int statusMacroDraftId = statusMacro.getDraftId().get();
        this.statusMacroManager.getStatusMacroByIdAndConfluencePageIdOrCreateDraftCopy(statusMacroDraftId, confluencePageId).ifPresent(statusMacroDraftCopy -> {
            log.debug("statusMacroDraftId = {}, confluencePageId = {}, statusMacroDraftCopy = {}.", new Object[]{statusMacroDraftId, confluencePageId, statusMacroDraftCopy});
            this.statusManager.getStatus(statusMacroDraftCopy.extractStatusId()).ifPresent(status -> this.statusLabelManager.removeLabel((StatusMacroDto)statusMacroDraftCopy, (StatusDto)status));
            this.statusMacroHistoryManager.createStatusMacroChange(statusMacroDraftCopy.getId(), statusMacro.getId(), statusMacro.getStatusSetId(), statusMacro.getStatusId(), statusMacro.isOutline(), author);
            this.statusMacroIdMapDao.createNewMapping(statusMacro.getId(), statusMacroDraftCopy.getId(), confluencePageId);
        });
        this.statusManager.getStatus(statusMacro.extractStatusId()).ifPresent(status -> this.statusLabelManager.addLabel(statusMacro, (StatusDto)status));
        this.statusMacroManager.unsetStatusMacroDraftId(statusMacro.getId());
        return this.statusMacroManager.getStatusMacro(statusMacro.getId());
    }

    private Optional<StatusDto> findStatusByName(Collection<StatusDto> statuses, String name) {
        return statuses.stream().filter(statusDto -> statusDto.getName().equalsIgnoreCase(name)).findFirst();
    }

    private String getStatusMacroCacheKey(long confluencePageId, int statusMacroId) {
        return confluencePageId + "-" + statusMacroId;
    }

    private static Function<StatusMacroDto, StatusMacroDto> logCachedStatusMacro(String statusMacroCacheKey) {
        return statusMacro -> {
            log.debug("StatusMacro from cache. key = {}, statusMacro = {}.", (Object)statusMacroCacheKey, statusMacro);
            return statusMacro;
        };
    }

    private String serializeStatusMacro(StatusMacroDto statusMacro) {
        return this.jsonSerializer.serialize(new StatusMacroCacheEntry(statusMacro));
    }

    private StatusMacroDto deserializeStatusMacro(String serializedStatusMacroCacheEntry) {
        return this.jsonSerializer.deserialize(serializedStatusMacroCacheEntry, StatusMacroCacheEntry.class).toStatusMacroDto();
    }
}

