/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroIdMapDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroManager
implements StatusMacroManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusMacroManager.class);
    private final StatusMacroDao statusMacroDao;
    private final StatusMacroIdMapDao statusMacroIdMapDao;

    public DefaultStatusMacroManager(StatusMacroDao statusMacroDao, StatusMacroIdMapDao statusMacroIdMapDao) {
        this.statusMacroDao = statusMacroDao;
        this.statusMacroIdMapDao = statusMacroIdMapDao;
    }

    @Override
    public StatusMacroDto createStatusMacro(int statusSetId, long statusId, boolean outline, @Nullable Long confluencePageId, boolean labelled, String labelPrefix, boolean isDraft) {
        log.debug("statusSetId = {}, statusId = {}, outline = {}, confluencePageId = {}, labelled = {}, labelPrefix = {}, isDraft = {}", new Object[]{statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, isDraft});
        StatusMacroEntity statusMacroEntity = this.createStatusMacroEntity(statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, isDraft);
        return this.toStatusMacro(statusMacroEntity);
    }

    @Override
    public StatusMacroDto createDraftStatusMacro(int sourceStatusMacroId, int statusSetId, long statusId, boolean outline, @Nullable Long confluencePageId, boolean labelled, String labelPrefix) {
        log.debug("sourceStatusMacroId = {}, statusSetId = {}, statusId = {}, confluencePageId = {}.", new Object[]{sourceStatusMacroId, statusSetId, statusId, confluencePageId});
        StatusMacroEntity draft = this.statusMacroDao.createDraftStatusMacroEntity(statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, sourceStatusMacroId);
        log.debug("draftStatusMacro = {}.", (Object)draft);
        return this.toStatusMacro(draft);
    }

    @Override
    public Optional<StatusMacroDto> updateStatusMacro(int statusMacroId, int statusSetId, long statusId, boolean outline, boolean labelled, String prefix, @Nullable Long confluencePageId) {
        Optional<StatusMacroEntity> entityOptional = this.getStatusMacroEntityByIdAndConfluencePageIdOrCreateDraftCopy(statusMacroId, confluencePageId);
        if (!entityOptional.isPresent()) {
            return Optional.empty();
        }
        StatusMacroEntity entity = entityOptional.get();
        if (entity.getDraftId() == null) {
            Optional<StatusMacroEntity> draftStatusMacroEntity = this.statusMacroDao.getStatusMacroEntityByDraftId(statusMacroId);
            if (draftStatusMacroEntity.isPresent()) {
                entity = draftStatusMacroEntity.get();
                entity.setStatusSetId(statusSetId);
                entity.setStatusId(statusId);
                entity.setOutline(outline);
                entity.setLabelled(labelled);
                entity.setLabelPrefix(prefix);
            } else {
                entity = this.statusMacroDao.createStatusMacroEntity(statusSetId, statusId, outline, entity.getConfluencePageId(), labelled, prefix);
                entity.setDraftId(statusMacroId);
            }
        } else {
            entity.setStatusSetId(statusSetId);
            entity.setStatusId(statusId);
            entity.setOutline(outline);
            entity.setLabelled(labelled);
            entity.setLabelPrefix(prefix);
        }
        entity.save();
        return Optional.of(entity).map(this::toStatusMacro);
    }

    @Override
    public StatusMacroDto changeStatusId(int statusMacroId, int statusId) {
        StatusMacroEntity entity = this.statusMacroDao.getStatusMacroEntity(statusMacroId).get();
        entity.setStatusId(statusId);
        entity.save();
        return this.toStatusMacro(entity);
    }

    @Override
    public StatusMacroDto getStatusMacro(int statusMacroId) {
        return this.getStatusMacroOptional(statusMacroId).orElseThrow(() -> new RuntimeException(String.format("Cannot find status macro with ID = %d.", statusMacroId)));
    }

    @Override
    public Optional<StatusMacroDto> getStatusMacroByIdOrByMapping(int statusMacroId) {
        log.debug("statusMacroId = {}.", (Object)statusMacroId);
        return this.getStatusMacroEntityByIdOrByMapping(statusMacroId).map(this::toStatusMacro);
    }

    @Override
    public Optional<StatusMacroDto> getStatusMacroByIdAndPageIdOrFindWithMapping(int statusMacroId, long confluencePageId) {
        log.debug("statusMacroId = {}, confluencePageId = {}.", (Object)statusMacroId, (Object)confluencePageId);
        Optional<StatusMacroDto> statusMacroOptional = this.getStatusMacroEntityByIdAndPageIdOrFindWithMapping(statusMacroId, confluencePageId).map(this::toStatusMacro);
        if (statusMacroOptional.isPresent()) {
            return statusMacroOptional;
        }
        return this.getStatusMacroEntityByIdOrByMapping(statusMacroId).map(this::toStatusMacro);
    }

    @Override
    public Optional<StatusMacroDto> getStatusMacroByIdAndConfluencePageIdOrCreateDraftCopy(int statusMacroId, @Nullable Long confluencePageId) {
        log.debug("statusMacroId = {}, confluencePageId = {}.", (Object)statusMacroId, (Object)confluencePageId);
        return this.getStatusMacroEntityByIdAndConfluencePageIdOrCreateDraftCopy(statusMacroId, confluencePageId).map(this::toStatusMacro);
    }

    @Override
    public Collection<StatusMacroDto> getStatusMacrosForPageWithLabel(long confluencePageId) {
        return this.statusMacroDao.getStatusMacroEntitiesForPageWithLabel(confluencePageId).stream().map(this::toStatusMacro).collect(Collectors.toList());
    }

    @Override
    public Collection<StatusMacroDto> getStatusMacrosWhereConfluencePageIdIsNotNull(int statusSetId, int offset, int limit) {
        return this.statusMacroDao.getStatusMacroEntitiesWhereConfluencePageIdIsNotNull(statusSetId, offset, limit).stream().map(this::toStatusMacro).collect(Collectors.toList());
    }

    @Override
    public Collection<StatusMacroDto> getStatusMacrosWhereConfluencePageIdIsNotNull(int statusSetId, int statusId, int offset, int limit) {
        return this.statusMacroDao.getStatusMacroEntitiesWhereConfluencePageIdIsNotNull(statusSetId, statusId, offset, limit).stream().map(this::toStatusMacro).collect(Collectors.toList());
    }

    @Override
    public void unsetStatusMacroDraftId(int statusMacroId) {
        log.debug("statusMacroId = {}.", (Object)statusMacroId);
        this.statusMacroDao.getStatusMacroEntity(statusMacroId).ifPresent(statusMacroEntity -> {
            statusMacroEntity.setDraftId(null);
            statusMacroEntity.save();
        });
    }

    private StatusMacroEntity createStatusMacroEntity(int statusSetId, long statusId, boolean outline, @Nullable Long confluencePageId, boolean labelled, String labelPrefix, boolean isDraft) {
        log.debug("statusSetId = {}, statusId = {}, outline = {}, confluencePageId = {}, labelled = {}, labelPrefix = {}, isDraft = {}", new Object[]{statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix, isDraft});
        StatusMacroEntity statusMacroEntity = this.statusMacroDao.createStatusMacroEntity(statusSetId, statusId, outline, confluencePageId, labelled, labelPrefix);
        if (isDraft) {
            statusMacroEntity.setDraftId(statusMacroEntity.getID());
            statusMacroEntity.save();
        }
        return statusMacroEntity;
    }

    private Optional<StatusMacroEntity> getStatusMacroEntityByIdAndConfluencePageIdOrCreateDraftCopy(int statusMacroId, @Nullable Long confluencePageId) {
        log.debug("statusMacroId = {}, confluencePageId = {}.", (Object)statusMacroId, (Object)confluencePageId);
        Optional<StatusMacroEntity> statusMacroEntityOptional = this.getStatusMacroEntityByIdAndPageIdOrFindWithMapping(statusMacroId, confluencePageId);
        if (statusMacroEntityOptional.isPresent()) {
            return statusMacroEntityOptional;
        }
        return this.getStatusMacroEntityByIdOrByMapping(statusMacroId).map(originStatusMacroEntity -> {
            log.debug("originStatusMacroEntity = {}.", originStatusMacroEntity);
            StatusMacroEntity draftStatusMacroEntity = this.copyStatusMacroEntityWithPageIdAsDraft(confluencePageId, (StatusMacroEntity)originStatusMacroEntity);
            log.debug("draftStatusMacro = {}.", (Object)draftStatusMacroEntity);
            this.statusMacroIdMapDao.createNewMapping(draftStatusMacroEntity.getID(), originStatusMacroEntity.getID(), confluencePageId);
            return draftStatusMacroEntity;
        });
    }

    private Optional<StatusMacroDto> getStatusMacroOptional(int statusMacroId) {
        return this.statusMacroDao.getStatusMacroEntity(statusMacroId).map(this::toStatusMacro);
    }

    private StatusMacroEntity copyStatusMacroEntityWithPageIdAsDraft(@Nullable Long confluencePageId, StatusMacroEntity origin) {
        boolean isLabeled = Optional.ofNullable(origin.getLabelled()).orElse(Boolean.FALSE);
        return this.createStatusMacroEntity(origin.getStatusSetId(), origin.getStatusId(), origin.getOutline(), confluencePageId, isLabeled, origin.getLabelPrefix(), true);
    }

    private Optional<StatusMacroEntity> getStatusMacroEntityByIdOrByMapping(int statusMacroId) {
        log.debug("statusMacroId = {}.", (Object)statusMacroId);
        Optional<StatusMacroEntity> statusMacroEntityOptional = this.statusMacroDao.getStatusMacroEntity(statusMacroId);
        if (statusMacroEntityOptional.isPresent()) {
            return statusMacroEntityOptional;
        }
        return this.statusMacroIdMapDao.getFirstStatusMacroIdByOldId(statusMacroId).map(newStatusMacroId -> {
            log.debug("mapping oldId = {}, newId = {}.", (Object)statusMacroId, newStatusMacroId);
            return newStatusMacroId;
        }).flatMap(this.statusMacroDao::getStatusMacroEntity);
    }

    private Optional<StatusMacroEntity> getStatusMacroEntityByIdAndPageIdOrFindWithMapping(int statusMacroId, @Nullable Long confluencePageId) {
        log.debug("statusMacroId = {}, confluencePageId = {}.", (Object)statusMacroId, (Object)confluencePageId);
        if (Objects.isNull(confluencePageId)) {
            return this.getStatusMacroEntityByIdOrByMapping(statusMacroId);
        }
        Optional<StatusMacroEntity> statusMacroEntityOptional = this.statusMacroDao.getStatusMacroEntity(statusMacroId, confluencePageId);
        if (statusMacroEntityOptional.isPresent()) {
            return statusMacroEntityOptional;
        }
        return this.statusMacroIdMapDao.getStatusMacroIdByOldIdAndConfluencePageId(statusMacroId, confluencePageId).flatMap(newStatusMacroId -> {
            log.debug("statusMacroId = {}, confluencePageId = {}, newStatusMacroId = {}.", new Object[]{statusMacroId, confluencePageId, newStatusMacroId});
            return this.statusMacroDao.getStatusMacroEntity((int)newStatusMacroId, confluencePageId);
        });
    }

    private StatusMacroDto toStatusMacro(StatusMacroEntity entity) {
        return StatusMacroDto.builder().id(entity.getID()).confluencePageId(entity.getConfluencePageId()).statusId(entity.getStatusId()).statusSetId(entity.getStatusSetId()).outline(entity.getOutline()).labeled(Boolean.TRUE.equals(entity.getLabelled())).labelPrefix(StringUtils.defaultString((String)entity.getLabelPrefix())).draftId(entity.getDraftId()).build();
    }
}

