/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.user.ConfluenceUser;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroHistoryManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroHistoryService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusManager;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusSetManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroChangeData;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroChangeDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusSetDto;
import com.stiltsoft.confluence.handy.macros.manager.HandyDateFormatter;
import com.stiltsoft.confluence.handy.macros.rest.entity.UserRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.history.StatusHistoryChangeRestEntity;
import com.stiltsoft.confluence.handy.macros.rest.status.entity.history.StatusHistoryRestEntity;
import com.stiltsoft.confluence.handy.macros.user.UserResourceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroHistoryService
implements StatusMacroHistoryService {
    private final StatusManager statusManager;
    private final StatusSetManager statusSetManager;
    private final HandyDateFormatter handyDateFormatter;
    private final UserResourceService userResourceService;
    private final StatusMacroHistoryManager statusMacroHistoryManager;

    @Autowired
    public DefaultStatusMacroHistoryService(StatusManager statusManager, StatusSetManager statusSetManager, HandyDateFormatter handyDateFormatter, UserResourceService userResourceService, StatusMacroHistoryManager statusMacroHistoryManager) {
        this.statusManager = statusManager;
        this.statusSetManager = statusSetManager;
        this.handyDateFormatter = handyDateFormatter;
        this.userResourceService = userResourceService;
        this.statusMacroHistoryManager = statusMacroHistoryManager;
    }

    @Override
    public List<StatusHistoryChangeRestEntity> getStatusHistoryChangeRestEntities(ConfluenceUser user, StatusMacroDto statusMacro) {
        DateFormatter dateFormatter = this.handyDateFormatter.getDateFormatter();
        ArrayList<StatusHistoryChangeRestEntity> restEntities = new ArrayList<StatusHistoryChangeRestEntity>(20);
        this.getStatusMacroChangesData(statusMacro.getId()).forEach(data -> {
            StatusMacroChangeDto change = data.getMacroChange();
            StatusHistoryRestEntity oldStatusRestEntity = this.getOldStatusHistoryRestEntity((StatusMacroChangeData)data, change);
            StatusDto newStatus = data.getNewStatus();
            StatusSetDto newStatusSet = data.getNewStatusSet();
            StatusHistoryRestEntity newStatusRestEntity = Objects.nonNull(newStatus) && Objects.nonNull(newStatusSet) ? this.getNewStatusHistoryRestEntity(change, newStatus, newStatusSet) : null;
            UserRestEntity userRestEntity = this.userResourceService.getUserRestEntity(change.getAuthorUserKey());
            String modificationDateFormatted = dateFormatter.formatDateTime(change.getModificationDate());
            StatusHistoryChangeRestEntity restEntity = StatusHistoryChangeRestEntity.builder().oldStatus(oldStatusRestEntity).newStatus(newStatusRestEntity).user(userRestEntity).date(modificationDateFormatted).build();
            restEntities.add(restEntity);
        });
        return restEntities;
    }

    private StatusHistoryRestEntity getNewStatusHistoryRestEntity(StatusMacroChangeDto change, StatusDto newStatus, StatusSetDto newStatusSet) {
        boolean newOutline = change.getNewOutline().orElse(Boolean.FALSE);
        return new StatusHistoryRestEntity(newStatus.getName(), newStatus.getBackgroundColor(), newStatus.getTextColorWithOutline(newOutline), newOutline, newStatusSet.getViewType(), newStatusSet.getWidth());
    }

    private StatusHistoryRestEntity getOldStatusHistoryRestEntity(StatusMacroChangeData data, StatusMacroChangeDto change) {
        StatusDto oldStatus = data.getOldStatus();
        StatusSetDto oldStatusSet = data.getOldStatusSet();
        return new StatusHistoryRestEntity(oldStatus.getName(), oldStatus.getBackgroundColor(), oldStatus.getTextColorWithOutline(change.isOldOutline()), change.isOldOutline(), oldStatusSet.getViewType(), oldStatusSet.getWidth());
    }

    private List<StatusMacroChangeData> getStatusMacroChangesData(int macroId) {
        HashMap statusById = new HashMap();
        HashMap statusSetById = new HashMap();
        ArrayList<StatusMacroChangeData> statusMacroChangesData = new ArrayList<StatusMacroChangeData>(20);
        this.statusMacroHistoryManager.getLastFifteenStatusMacroChanges(macroId).forEach(change -> {
            StatusDto oldStatus = this.getStatusFromMapOrDB(change.extractOldStatusId(), statusById);
            StatusSetDto oldStatusSet = this.getStatusSetFromMapOrDB(change.getOldStatusSetId(), statusSetById);
            StatusDto newStatus = null;
            StatusSetDto newStatusSet = null;
            if (change.isPresentNewStatusAndSet()) {
                int newStatusId = Math.toIntExact(change.getNewStatusId().get());
                newStatus = this.getStatusFromMapOrDB(newStatusId, statusById);
                int newStatusSetId = change.getNewStatusSetId().get();
                newStatusSet = this.getStatusSetFromMapOrDB(newStatusSetId, statusSetById);
            }
            StatusMacroChangeData changeData = StatusMacroChangeData.builder().macroChange((StatusMacroChangeDto)change).oldStatus(oldStatus).oldStatusSet(oldStatusSet).newStatus(newStatus).newStatusSet(newStatusSet).build();
            statusMacroChangesData.add(changeData);
        });
        return statusMacroChangesData;
    }

    private StatusDto getStatusFromMapOrDB(int statusId, Map<Integer, StatusDto> statusById) {
        if (statusById.containsKey(statusId)) {
            return statusById.get(statusId);
        }
        StatusDto statusDto = this.statusManager.getStatus(statusId).orElse(StatusDto.UNKNOWN_STATUS);
        statusById.put(statusId, statusDto);
        return statusDto;
    }

    private StatusSetDto getStatusSetFromMapOrDB(int statusSetId, Map<Integer, StatusSetDto> statusSetById) {
        if (statusSetById.containsKey(statusSetId)) {
            return statusSetById.get(statusSetId);
        }
        StatusSetDto statusSetDto = this.statusSetManager.getStatusSetById(statusSetId).get();
        statusSetById.put(statusSetId, statusSetDto);
        return statusSetDto;
    }
}

