/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroHistoryManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroChangesDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroChangeEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroEntity;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroChangeDto;
import com.stiltsoft.confluence.handy.macros.util.UserUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import net.java.ao.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroHistoryManager
implements StatusMacroHistoryManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusMacroHistoryManager.class);
    private final StatusMacroDao statusMacroDao;
    private final TransactionTemplate transactionTemplate;
    private final StatusMacroChangesDao statusMacroChangesDao;

    public DefaultStatusMacroHistoryManager(StatusMacroDao statusMacroDao, TransactionTemplate transactionTemplate, StatusMacroChangesDao statusMacroChangesDao) {
        this.statusMacroDao = statusMacroDao;
        this.transactionTemplate = transactionTemplate;
        this.statusMacroChangesDao = statusMacroChangesDao;
    }

    @Override
    public StatusMacroChangeDto getLastStatusMacroChange(int statusMacroId) {
        return this.statusMacroChangesDao.getLastStatusMacroChangeEntity(statusMacroId).map(this::toStatusMacroHistory).orElseThrow(() -> new RuntimeException(String.format("Cannot find StatusMacroHistory with id = %d", statusMacroId)));
    }

    @Override
    public List<StatusMacroChangeDto> getLastFifteenStatusMacroChanges(int statusMacroId) {
        return this.statusMacroChangesDao.getLastFifteenStatusMacroChangeEntities(statusMacroId).stream().map(this::toStatusMacroHistory).collect(Collectors.toList());
    }

    @Override
    public void createStatusMacroChange(int currentStatusMacroId, int newStatusMacroId, @Nullable Integer newStatusSetId, @Nullable Long newStatusId, @Nullable Boolean newOutline, @Nullable ConfluenceUser author) {
        log.debug("currentStatusMacroId = {}, newStatusMacroId = {}, newStatusSetId = {}, newStatusId = {}, newOutline = {}, author = {}.", new Object[]{currentStatusMacroId, newStatusMacroId, newStatusSetId, newStatusId, newOutline, author});
        String confluenceUserKey = UserUtil.getConfluenceUserKey(author).orElse("");
        this.transactionTemplate.execute(() -> {
            this.statusMacroDao.getStatusMacroEntity(currentStatusMacroId).ifPresent(statusMacroEntity -> this.removeOldOneAndCreateNewStatusMacroChangeEntity((StatusMacroEntity)statusMacroEntity, newStatusMacroId, newStatusSetId, newStatusId, newOutline, confluenceUserKey));
            return null;
        });
    }

    private void removeOldOneAndCreateNewStatusMacroChangeEntity(StatusMacroEntity statusMacroEntity, int newStatusMacroId, @Nullable Integer newStatusSetId, @Nullable Long newStatusId, @Nullable Boolean newOutline, String confluenceUserKey) {
        int oldStatusMacroId = statusMacroEntity.getID();
        int oldStatusSetId = statusMacroEntity.getStatusSetId();
        long oldStatusId = statusMacroEntity.getStatusId();
        boolean oldOutline = statusMacroEntity.getOutline();
        ArrayList<StatusMacroChangeEntity> changeEntities = new ArrayList<StatusMacroChangeEntity>(20);
        changeEntities.addAll(this.statusMacroChangesDao.getLastFifteenStatusMacroChangeEntities(oldStatusMacroId));
        if (!(Objects.equals(oldStatusSetId, newStatusSetId) && Objects.equals(oldStatusId, newStatusId) && Objects.equals(oldOutline, newOutline))) {
            this.statusMacroChangesDao.createStatusMacroChangeEntity(newStatusMacroId, oldStatusSetId, oldStatusId, oldOutline, newStatusSetId, newStatusId, newOutline, confluenceUserKey, System.currentTimeMillis());
        }
        if (changeEntities.size() >= 15) {
            StatusMacroChangeEntity entityForDeleting = (StatusMacroChangeEntity)changeEntities.remove(14);
            int statusMacroHistoryEntityId = entityForDeleting.getID();
            this.statusMacroChangesDao.deleteStatusMacroChangeEntity(statusMacroHistoryEntityId);
        }
        if (newStatusMacroId != oldStatusMacroId) {
            List<Integer> statusMacroChangeIds = changeEntities.stream().map(Entity::getID).collect(Collectors.toList());
            this.statusMacroChangesDao.updateStatusMacroId(statusMacroChangeIds, newStatusMacroId);
        }
    }

    private StatusMacroChangeDto toStatusMacroHistory(StatusMacroChangeEntity entity) {
        return StatusMacroChangeDto.builder().id(entity.getID()).statusMacroId(entity.getStatusMacroId()).oldStatusSetId(entity.getOldStatusSetId()).oldStatusId(entity.getOldStatusId()).oldOutline(entity.getOldOutline()).newStatusSetId(entity.getNewStatusSetId()).newStatusId(entity.getNewStatusId()).newOutline(entity.getNewOutline()).authorUserKey(entity.getAuthorUserKey()).modificationTimestamp(entity.getModificationTimestamp()).build();
    }
}

