/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.impl;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.LabelUtil;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusLabelManager;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusDto;
import com.stiltsoft.confluence.handy.macros.macro.status.dto.StatusMacroDto;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusLabelManager
implements StatusLabelManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusLabelManager.class);
    private final LabelManager labelManager;
    private final PageManager pageManager;

    public DefaultStatusLabelManager(LabelManager labelManager, PageManager pageManager) {
        this.labelManager = labelManager;
        this.pageManager = pageManager;
    }

    @Override
    public void removeLabel(StatusMacroDto statusMacro, StatusDto status) {
        log.debug("statusMacro = {}, status = {}.", (Object)statusMacro, (Object)status);
        this.getPageStatusAndMacroThenProcessLabel(statusMacro, status, pairLabelPage -> {
            String label = (String)pairLabelPage.getLeft();
            AbstractPage page = (AbstractPage)pairLabelPage.getRight();
            this.labelManager.removeLabel((Labelable)page, new Label(label));
        });
    }

    @Override
    public void addLabel(StatusMacroDto statusMacro, StatusDto status) {
        log.debug("statusMacro = {}, status = {}.", (Object)statusMacro, (Object)status);
        this.getPageStatusAndMacroThenProcessLabel(statusMacro, status, pairLabelPage -> {
            String label = (String)pairLabelPage.getLeft();
            AbstractPage page = (AbstractPage)pairLabelPage.getRight();
            LabelUtil.addLabel((String)label, (LabelManager)this.labelManager, (Labelable)page);
        });
    }

    private void getPageStatusAndMacroThenProcessLabel(StatusMacroDto statusMacro, StatusDto status, Consumer<ImmutablePair<String, AbstractPage>> pairConsumer) {
        statusMacro.getConfluencePageId().map(arg_0 -> ((PageManager)this.pageManager).getAbstractPage(arg_0)).ifPresent(page -> {
            String label = this.getLabel(statusMacro, status);
            if (!label.isEmpty()) {
                pairConsumer.accept(new ImmutablePair((Object)label, page));
            }
        });
    }

    private String getLabel(StatusMacroDto statusMacro, StatusDto status) {
        if (!statusMacro.isLabeled()) {
            return statusMacro.getLabelPrefix();
        }
        Object label = statusMacro.getLabelPrefix();
        label = (String)label + status.getName();
        return ((String)label).replaceAll("[:;,.?&\\[\\]\\(\\)#\\^\\*@\\!\\s]", "_");
    }
}

