/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.extractor;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusMacroService;
import com.stiltsoft.confluence.handy.macros.macro.status.StatusesService;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusSearchIndexExtractor
implements Extractor2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusSearchIndexExtractor.class);
    public static final String STATUS_FIELD = "status";
    private final XhtmlContent xhtmlContent;
    private final StatusesService statusesService;
    private final StatusMacroService statusMacroService;

    public StatusSearchIndexExtractor(XhtmlContent xhtmlContent, StatusesService statusesService, StatusMacroService statusMacroService) {
        this.xhtmlContent = xhtmlContent;
        this.statusesService = statusesService;
        this.statusMacroService = statusMacroService;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (searchable instanceof AbstractPage || searchable instanceof Comment) {
            ContentEntityObject ceo = (ContentEntityObject)searchable;
            String pageBody = ceo.getBodyAsString();
            PageContext pageContext = ceo.toPageContext();
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)pageContext);
            try {
                this.xhtmlContent.handleMacroDefinitions(pageBody, (ConversionContext)conversionContext, macroDefinition -> {
                    if ("status-handy".equals(macroDefinition.getName())) {
                        int statusMacroId = Integer.parseInt((String)macroDefinition.getParameters().get("id"));
                        this.statusMacroService.getCachedStatusMacroOrFindWithMapping(statusMacroId, ceo.getId()).map(statusMacro -> Math.toIntExact(statusMacro.getStatusId())).flatMap(this.statusesService::getStatusFromCacheOrDB).ifPresent(status -> fieldDescriptors.add(new FieldDescriptor(STATUS_FIELD, status.getName(), FieldDescriptor.Store.NO, FieldDescriptor.Index.ANALYZED)));
                    } else if (STATUS_FIELD.equals(macroDefinition.getName())) {
                        String status2 = macroDefinition.getParameter("title");
                        if (status2 == null) {
                            status2 = StringUtils.defaultString((String)macroDefinition.getParameter("colour"), (String)"grey");
                        }
                        fieldDescriptors.add(new FieldDescriptor(STATUS_FIELD, status2, FieldDescriptor.Store.NO, FieldDescriptor.Index.ANALYZED));
                    }
                });
            }
            catch (Exception e) {
                log.error("Failed to index Handy Statuses, content id is: " + ((ContentEntityObject)searchable).getIdAsString(), (Throwable)e);
            }
        }
        return fieldDescriptors;
    }

    public StringBuilder extractText(Object searchable) {
        return new StringBuilder(0);
    }
}

