/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dto;

import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusSetEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class StatusSetDto
implements Comparable<StatusSetDto> {
    public static final int DEFAULT_STATUS_WIDTH = 88;
    private final int id;
    private final String name;
    private final String owner;
    @Nullable
    private final Integer parentId;
    @Nullable
    private final Integer viewType;
    @Nullable
    private final Integer width;

    public StatusSetDto(StatusSetEntity set) {
        this.id = set.getID();
        this.name = Objects.isNull(set.getName()) ? "" : set.getName();
        this.owner = set.getOwner();
        this.parentId = set.getParent();
        this.viewType = set.getViewType();
        this.width = set.getWidth();
    }

    public StatusSetDto(int id, @Nullable String name, String owner, @Nullable Integer parentId, @Nullable Integer viewType, @Nullable Integer width) {
        this.id = id;
        this.name = Objects.isNull(name) ? "" : name;
        this.owner = owner;
        this.parentId = parentId;
        this.viewType = viewType;
        this.width = width;
    }

    public int getWidthOrDefault() {
        if (Objects.nonNull(this.viewType) && Objects.nonNull(this.width) && this.viewType.equals(1)) {
            return this.width + 12;
        }
        if (Objects.nonNull(this.width)) {
            return this.width;
        }
        return 88;
    }

    @Override
    public int compareTo(@Nonnull StatusSetDto o) {
        return this.name.compareToIgnoreCase(o.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusSetDto that = (StatusSetDto)o;
        return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.owner, that.owner) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.viewType, that.viewType) && Objects.equals(this.width, that.width);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.owner, this.parentId, this.viewType, this.width);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Nullable
    @Generated
    public Integer getParentId() {
        return this.parentId;
    }

    @Nullable
    @Generated
    public Integer getViewType() {
        return this.viewType;
    }

    @Nullable
    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public String toString() {
        return "StatusSetDto(id=" + this.getId() + ", name=" + this.getName() + ", owner=" + this.getOwner() + ", parentId=" + this.getParentId() + ", viewType=" + this.getViewType() + ", width=" + this.getWidth() + ")";
    }
}

