/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dto;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class StatusMacroDto {
    private final int id;
    @Nullable
    private final Long confluencePageId;
    private final long statusId;
    private final int statusSetId;
    private final boolean outline;
    private final boolean labeled;
    @Nonnull
    private final String labelPrefix;
    @Nullable
    private final Integer draftId;

    public Optional<Long> getConfluencePageId() {
        return Optional.ofNullable(this.confluencePageId);
    }

    public long getConfluencePageIdOrNegativeValue() {
        return this.getConfluencePageId().orElse(-1L);
    }

    public Optional<Integer> getDraftId() {
        return Optional.ofNullable(this.draftId);
    }

    public int extractStatusId() {
        return Math.toIntExact(this.statusId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusMacroDto that = (StatusMacroDto)o;
        return this.id == that.id && this.statusId == that.statusId && this.statusSetId == that.statusSetId && this.outline == that.outline && this.labeled == that.labeled && Objects.equals(this.confluencePageId, that.confluencePageId) && this.labelPrefix.equals(that.labelPrefix) && Objects.equals(this.draftId, that.draftId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.confluencePageId, this.statusId, this.statusSetId, this.outline, this.labeled, this.labelPrefix, this.draftId);
    }

    @Generated
    public static StatusMacroDtoBuilder builder() {
        return new StatusMacroDtoBuilder();
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public long getStatusId() {
        return this.statusId;
    }

    @Generated
    public int getStatusSetId() {
        return this.statusSetId;
    }

    @Generated
    public boolean isOutline() {
        return this.outline;
    }

    @Generated
    public boolean isLabeled() {
        return this.labeled;
    }

    @Nonnull
    @Generated
    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    @Generated
    public String toString() {
        return "StatusMacroDto(id=" + this.getId() + ", confluencePageId=" + this.getConfluencePageId() + ", statusId=" + this.getStatusId() + ", statusSetId=" + this.getStatusSetId() + ", outline=" + this.isOutline() + ", labeled=" + this.isLabeled() + ", labelPrefix=" + this.getLabelPrefix() + ", draftId=" + this.getDraftId() + ")";
    }

    @Generated
    public StatusMacroDto(int id, @Nullable Long confluencePageId, long statusId, int statusSetId, boolean outline, boolean labeled, @Nonnull String labelPrefix, @Nullable Integer draftId) {
        if (labelPrefix == null) {
            throw new NullPointerException("labelPrefix is marked non-null but is null");
        }
        this.id = id;
        this.confluencePageId = confluencePageId;
        this.statusId = statusId;
        this.statusSetId = statusSetId;
        this.outline = outline;
        this.labeled = labeled;
        this.labelPrefix = labelPrefix;
        this.draftId = draftId;
    }

    @Generated
    public static class StatusMacroDtoBuilder {
        @Generated
        private int id;
        @Generated
        private Long confluencePageId;
        @Generated
        private long statusId;
        @Generated
        private int statusSetId;
        @Generated
        private boolean outline;
        @Generated
        private boolean labeled;
        @Generated
        private String labelPrefix;
        @Generated
        private Integer draftId;

        @Generated
        StatusMacroDtoBuilder() {
        }

        @Generated
        public StatusMacroDtoBuilder id(int id) {
            this.id = id;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder confluencePageId(@Nullable Long confluencePageId) {
            this.confluencePageId = confluencePageId;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder statusId(long statusId) {
            this.statusId = statusId;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder statusSetId(int statusSetId) {
            this.statusSetId = statusSetId;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder outline(boolean outline) {
            this.outline = outline;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder labeled(boolean labeled) {
            this.labeled = labeled;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder labelPrefix(@Nonnull String labelPrefix) {
            if (labelPrefix == null) {
                throw new NullPointerException("labelPrefix is marked non-null but is null");
            }
            this.labelPrefix = labelPrefix;
            return this;
        }

        @Generated
        public StatusMacroDtoBuilder draftId(@Nullable Integer draftId) {
            this.draftId = draftId;
            return this;
        }

        @Generated
        public StatusMacroDto build() {
            return new StatusMacroDto(this.id, this.confluencePageId, this.statusId, this.statusSetId, this.outline, this.labeled, this.labelPrefix, this.draftId);
        }

        @Generated
        public String toString() {
            return "StatusMacroDto.StatusMacroDtoBuilder(id=" + this.id + ", confluencePageId=" + this.confluencePageId + ", statusId=" + this.statusId + ", statusSetId=" + this.statusSetId + ", outline=" + this.outline + ", labeled=" + this.labeled + ", labelPrefix=" + this.labelPrefix + ", draftId=" + this.draftId + ")";
        }
    }
}

