/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dto;

import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusEntity;
import com.stiltsoft.confluence.handy.macros.manager.ColorHelper;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class StatusDto {
    public static final String DEFAULT_STATUS_NAME = "unknown";
    public static final String DEFAULT_BACKGROUND_COLOR = "#cccccc";
    public static final StatusDto UNKNOWN_STATUS = new StatusDto(-1, "unknown", "#cccccc", "#000000", -1);
    private final int id;
    private final String name;
    private final String backgroundColor;
    private final String textColor;
    private final int statusSetId;

    public StatusDto(StatusEntity entity) {
        this(entity.getID(), entity.getName(), entity.getBackgroundColor(), StringUtils.defaultString((String)entity.getTextColor()), entity.getStatusSet().getID());
    }

    public String getTextOrContrastColor() {
        return this.textColor.isEmpty() ? ColorHelper.getContrastColor(this.backgroundColor) : this.textColor;
    }

    public String getTextColorWithOutline(boolean outline) {
        if (this.textColor.isEmpty()) {
            if (!outline) {
                return ColorHelper.getContrastColor(this.backgroundColor);
            }
            if (ColorHelper.colorsReadable(this.backgroundColor, "#ffffff")) {
                return this.backgroundColor;
            }
            return "black";
        }
        if (outline) {
            if (ColorHelper.colorsReadable(this.backgroundColor, "#ffffff")) {
                return this.backgroundColor;
            }
            return "black";
        }
        return this.textColor;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public String getTextColor() {
        return this.textColor;
    }

    @Generated
    public int getStatusSetId() {
        return this.statusSetId;
    }

    @Generated
    public String toString() {
        return "StatusDto(id=" + this.getId() + ", name=" + this.getName() + ", backgroundColor=" + this.getBackgroundColor() + ", textColor=" + this.getTextColor() + ", statusSetId=" + this.getStatusSetId() + ")";
    }

    @Generated
    public StatusDto(int id, String name, String backgroundColor, String textColor, int statusSetId) {
        this.id = id;
        this.name = name;
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.statusSetId = statusSetId;
    }
}

