/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusSetDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusSetEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusSetDao
implements StatusSetDao {
    private final ActiveObjects ao;

    public DefaultStatusSetDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Optional<StatusSetEntity> getStatusSetEntityById(int statusSetId) {
        return Optional.ofNullable((StatusSetEntity)this.ao.get(StatusSetEntity.class, (Object)statusSetId));
    }

    @Override
    public List<StatusSetEntity> getStatusSetEntitiesByOwner(String owner) {
        Query query = Query.select().from(StatusSetEntity.class).where(String.format("%s = ?", "OWNER"), new Object[]{owner});
        return Arrays.asList((StatusSetEntity[])this.ao.find(StatusSetEntity.class, query));
    }

    @Override
    public List<StatusSetEntity> getStatusSetEntitiesBySpaceOwner(String spaceOwner) {
        String spaceOwnerLC = spaceOwner.toLowerCase();
        String spaceOwnerUC = spaceOwner.toUpperCase();
        String clause = String.format("%s = ? OR %s = ? OR %s = ?", "OWNER", "OWNER", "OWNER");
        Query query = Query.select().from(StatusSetEntity.class).where(clause, new Object[]{spaceOwner, spaceOwnerLC, spaceOwnerUC});
        return Arrays.asList((StatusSetEntity[])this.ao.find(StatusSetEntity.class, query));
    }

    @Override
    public StatusSetEntity createStatusSetEntity(String name, String owner, Integer parentId, Integer viewType, Integer width) {
        return (StatusSetEntity)this.ao.create(StatusSetEntity.class, new DBParam[]{new DBParam("NAME", (Object)name), new DBParam("OWNER", (Object)owner), new DBParam("PARENT", (Object)parentId), new DBParam("VIEW_TYPE", (Object)viewType), new DBParam("WIDTH", (Object)width)});
    }

    @Override
    public void removeStatusSetEntityById(int statusSetId) {
        this.ao.deleteWithSQL(StatusSetEntity.class, "ID = ?", new Object[]{statusSetId});
    }
}

