/*
 * Decompiled with CFR 0.152.
 */
package com.stiltsoft.confluence.handy.macros.macro.status.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.StatusMacroIdMapDao;
import com.stiltsoft.confluence.handy.macros.macro.status.dao.activeobjects.StatusMacroIdMapEntity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
public class DefaultStatusMacroIdMapDao
implements StatusMacroIdMapDao {
    private final ActiveObjects ao;

    public DefaultStatusMacroIdMapDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Optional<Integer> getLastStatusMacroIdByOldId(int oldStatusMacroId) {
        return this.getCurrentIdByOldId(oldStatusMacroId, "DESC");
    }

    @Override
    public Optional<Integer> getFirstStatusMacroIdByOldId(int oldStatusMacroId) {
        return this.getCurrentIdByOldId(oldStatusMacroId, "ASC");
    }

    @Override
    public Optional<Integer> getStatusMacroIdByOldIdAndConfluencePageId(int oldStatusMacroId, long confluencePageId) {
        String clause = String.format("%s = ? AND %s = ?", "OLD_ID", "PAGE_ID");
        Query query = Query.select((String)"CURRENT_ID").where(clause, new Object[]{oldStatusMacroId, confluencePageId}).limit(1);
        return Stream.of((StatusMacroIdMapEntity[])this.ao.find(StatusMacroIdMapEntity.class, query)).findFirst().map(StatusMacroIdMapEntity::getCurrentId);
    }

    @Override
    public List<Integer> getOldStatusMacroIds(int currentStatusMacroId, long confluencePageId) {
        String clause = String.format("%s = ? AND %s = ?", "CURRENT_ID", "PAGE_ID");
        Query query = Query.select((String)"OLD_ID").where(clause, new Object[]{currentStatusMacroId, confluencePageId}).limit(1);
        return Stream.of((StatusMacroIdMapEntity[])this.ao.find(StatusMacroIdMapEntity.class, query)).map(Entity::getID).collect(Collectors.toList());
    }

    @Override
    public void createNewMapping(int newStatusMacroId, int currentStatusMacroId, @Nullable Long confluencePageId) {
        this.updateCurrentIdForStatusMacroIdMapEntity(newStatusMacroId, currentStatusMacroId, confluencePageId);
        this.createStatusMacroIdMapEntity(newStatusMacroId, currentStatusMacroId, confluencePageId);
    }

    private void updateCurrentIdForStatusMacroIdMapEntity(int newStatusMacroId, int currentStatusMacroId, @Nullable Long confluencePageId) {
        String clause = String.format("%s = ? AND %s = ?", "CURRENT_ID", "PAGE_ID");
        Query query = Query.select((String)"CURRENT_ID").where(clause, new Object[]{currentStatusMacroId, confluencePageId});
        Stream.of((StatusMacroIdMapEntity[])this.ao.find(StatusMacroIdMapEntity.class, query)).forEach(statusMacroIdMapEntity -> {
            statusMacroIdMapEntity.setCurrentId(newStatusMacroId);
            statusMacroIdMapEntity.save();
        });
    }

    private void createStatusMacroIdMapEntity(int newStatusMacroId, int currentStatusMacroId, @Nullable Long confluencePageId) {
        this.ao.create(StatusMacroIdMapEntity.class, new DBParam[]{new DBParam("CURRENT_ID", (Object)newStatusMacroId), new DBParam("OLD_ID", (Object)currentStatusMacroId), new DBParam("PAGE_ID", (Object)confluencePageId)});
    }

    private Optional<Integer> getCurrentIdByOldId(int oldStatusMacroId, String order) {
        String whereClause = String.format("%s = ?", "OLD_ID");
        String orderClause = String.format("%s %s", "CURRENT_ID", order);
        Query query = Query.select((String)"CURRENT_ID").where(whereClause, new Object[]{oldStatusMacroId}).order(orderClause).limit(1);
        return Stream.of((StatusMacroIdMapEntity[])this.ao.find(StatusMacroIdMapEntity.class, query)).findFirst().map(StatusMacroIdMapEntity::getCurrentId);
    }
}

